/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate;

import org.zhiqim.httpd.util.Scripts;

/**
 * 单字段比较大小验证抽象类，提供基础的属性，实现由子类完成
 * 1、通过min判断是否支持为空
 * 2、提供通用的比较大小的JS方法
 *
 * @version v1.0.0 @author zhichenggang 2017-10-14 新建与整理
 */
public abstract class OneValidateMinMax extends OneValidate
{
    protected int min;
    protected int max;
    
    /** 默认构造，是否允许为空取值min==0 */
    public OneValidateMinMax(String field, String alert, int min, int max)
    {
        super(field, alert, min == 0);
        this.min = min;
        this.max = max;
    }
    
    /** 构造函数，是否允许为空取值min==0，支持把错误信息传到elementId中 */
    public OneValidateMinMax(String field, String alert, String elementId, int min, int max)
    {
        super(field, alert, min == 0,  elementId);
        this.min = min;
        this.max = max;
    }
    
    /** 构造函数，是否允许为空取值min==0，支持判断是否响应焦点 */
    public OneValidateMinMax(String field, String alert, boolean isFocus, int min, int max)
    {
        super(field, alert, min == 0, isFocus);
        this.min = min;
        this.max = max;
    }
    
    /** 获取该验证的判断代码 */
    public String getScript()
    {
        return Scripts.buildValidateScriptMinMax(getName(), field, alert, elementId, isFocus, min, max);
    }
}
