/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.util;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.context.service.VcodeService;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.paging.PageResult;

/**
 * 对HttpSession进行一级封装，实现相关的数据提取工具类，分隔HttpSession代码
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Sessions")
public class Sessions
{

    /*************************************************************************/
    //获取会话中的特定值，和删除指定的会话
    /*************************************************************************/
    
    /**
     * 获取session中的验证码
     * 
     * @param request 请求
     * @return String 验证码值
     */
    public static String getSessionVerificationCode(HttpRequest request)
    {
        return request.getSessionAttributeString(VcodeService.ZC_VCODE_SESSION_NAME);
    }
    
    /**
     * 获取session中的用户对象列表
     * 
     * @param request 请求
     * @return User子类
     */
    public static PageResult<HttpSessionUser> getSessionUserPage(HttpRequest request, int pageNo, int pageSize)
    {
        return request.getContext().getSessionManager().getSessionUserPage(pageNo, pageSize);
    }

    /**
     * 获取session中的用户对象
     * 
     * @param request 请求
     * @return User子类
     */
    public static HttpSessionUser getSessionUser(HttpRequest request, String sessionId)
    {
        HttpSession session = request.getContext().getSessionManager().getSession(sessionId);
        return session == null?null:session.getSessionUser();
    }
    
    /**
     * 删除session中的指定的用户对象
     * 
     * @param request 请求
     * @param sessionId 会话编号
     */
    public static void removeSession(HttpRequest request, String sessionId)
    {
        request.getContext().getSessionManager().invalidateSession(sessionId);
    }
}
