/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.util;

import java.util.Map;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.HtmlConstants;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Strings;

/**
 * Script工具类
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Scripts")
public class Scripts extends Scriptx implements RegexpConstants, HtmlConstants
{
    /** 填充Script头部内容 */
    public static String head()
    {
        return _SCRIPT_BR;
    }
    
    /** 填充Script尾部内容 */
    public static String tail()
    {
        return SCRIPT_;
    }
    
    /** 填充Script指定源地址 */
    public static String src(String src)
    {
        return "<script src=\""+src+"\"></script>";
    }
    
    public static String src(String src, String props)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_SCRIPT_PRE);
        strb.append(" src=\"").append(src).append("\"");
        
        MapSS propMap = Jsons.toMapSS(props);
        for (Map.Entry<String, String> entry : propMap.entrySet())
        {
            strb.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        
        strb.append(SCRIPT_);
        strb.append(_BR_);
        return strb.toString();
    }
    
    /** 填充jQuery下载百度的CDN地址 */
    public static String jQuery(String version)
    {
        if (Strings.getTimes(version, '.') == 1) version = version + ".0";
        return src("//apps.bdimg.com/libs/jquery/"+version+"/jquery.min.js");
    }
    
    /** 加载 */
    public static String onload(String load)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_SCRIPT);
        strb.append("Z.onload(function(){").append(load).append("});");
        strb.append(SCRIPT_);
        return strb.toString();
    }
    
    /** 格式化 */
    public static String formatAlertMsg(String message)
    {
        //1.回车换行转换\r成\\r,\n成\\n，以保证js按行解析正确
        message = message.replaceAll("\r","\\\\r");
        message = message.replaceAll("\n","\\\\n");
        //2.双引号和单引号统一前加\，由于js也可解析\"，需多次转化
        message = message.replaceAll("\"", "\\\\\"");
        message = message.replaceAll("\'", "\\\\\'");
        return message;
    }
    
    /** 重新加载父窗口 */
    public static String doReloadParent()
    {
        return "<script>parent.location.reload();</script>";
    }
    
    /** 重新加载父窗口，先提示后加载 */
    public static String doReloadParent(String alert)
    {
        return "<script>top.Z.success(\""+alert+"\", function(){parent.location.reload();});</script>";
    }
    
    /** 重定向父窗口 */
    public static String doLocationParent(String url)
    {
        return "<script>parent.location.href = \""+url+"\";</script>";
    }
    
    /** 重定向父窗口，先提示后重定向 */
    public static String doLocationParent(String url, String alert)
    {
        return "<script>top.Z.success(\""+alert+"\", function(){parent.location.href = \""+url+"\";});</script>";
    }
    
    /*************************************/
    //正则表达式相关
    /*************************************/
    
    /**
     * 是否符号正则表达式
     * 
     * @param regexp        正则表达式
     * @return              得到指定函数名称的函数内容
     */
    public static String isRegexp(String regexp)
    {
        return Scriptx.isRegexp(regexp, false);
    }
    
    /** 是否是数字 */
    public static String isNumeric()
    {
        return Scriptx.isNumeric(false);
    }
    
    /** 是否是整数，包括正整数、负整数、和0，支持-号、不支持+号 */
    public static String isInteger()
    {
        return Scriptx.isInteger(false);
    }
    
    /** 是否是字母和数字组合 */
    public static String isAlphaNumeric()
    {
        return Scriptx.isAlphaNumeric(false);
    }
    
    /** 是否浮点型，支持多位小数，支持负数，如-12,-12.3,-12.35,-12.356,12,12.3,12.35,0,0.3,0.35,-0.3,-0.35，不支持+12,+12,35之类的前缀+号 */
    public static String isFloat()
    {
        return Scriptx.isFloat(false);
    }
    
    /** 是否是最长两位小数的金额，支持负数，如-12,-12.3,-12.35,12,12.3,12.35,0,0.3,0.35,-0.3,-0.35，不支持+12,+12,35之类的前缀+号 */
    public static String isAmount2R()
    {
        return Scriptx.isAmount2R(false);
    }
    
    /** 是否是邮箱地址，支持类似于xxx@xxx.xxx的邮箱格式，支持[-_.]等连接符，不支持中文等特殊符号 */
    public static String isEmail()
    {
        return Scriptx.isEmail(false);
    }
    
    /** 是否是IP地址，支持类似于192.168.1.1/192.168.01.01/192.168.001.001的IP格式 */
    public static String isIP()
    {
        return Scriptx.isIP(false);
    }
    
    /** 是否是MAC地址，格式为23:ad:87:be(十六进制) */
    public static String isMacAddress()
    {
        return Scriptx.isMacAddress(false);
    }
    
    /** 是否是泛手机号码，支持前缀+86,86开头,后面接手机号 */
    public static String isMobile()
    {
        return Scriptx.isMobile(false);
    }
    
    /** 是否是中国区11位的手机号码 */
    public static String isMobile11()
    {
        return Scriptx.isMobile11(false);
    }
    
    /** 是否是日期格式，格式为yyyy-MM-dd */
    public static String isDate()
    {
        return Scriptx.isDate(false);
    }
    
    /** 是否是时间格式，格式为HH:mm:ss */
    public static String isTime()
    {
        return Scriptx.isTime(false);
    }
    
    /** 是否是日期时间格式，格式为yyyy-MM-dd HH:mm:ss */
    public static String isDateTime()
    {
        return Scriptx.isDateTime(false);
    }
    
    /** 是否是身份证号，格式为[0-9]{6}yyyyMMdd[0-9]{3}[0-9xX*]，前6位数字，中间8位1900-2099年的日期，末4位为3个数字和[0-9]或xX*。*/
    public static String isIdcard()
    {
        return Scriptx.isIdcard(false);
    }
    
    /** 是否是邮政编码 */
    public static String isPostalCode()
    {
        return Scriptx.isPostalCode(false);
    }
    
    /*************************************/
    //判断条件相关
    /*************************************/
    
    /** 是否为空 */
    public static String isEmpty()
    {
        return new StringBuilder()
        .append("function ").append(IS_EMPTY).append("(value)").append(_BR_)
        .append("{").append(_BR_)
        .append(_FOUR_).append("if (value == null || value == '' || value.length < 1)").append(_BR_)
        .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
        .append(_BR_)
        .append(_FOUR_).append("for (var i=0;i<value.length;i++)").append(_BR_)
        .append(_FOUR_).append("{").append(_BR_)
        .append(_FOUR_).append(_FOUR_).append("if (value.charAt(i) > String.fromCharCode(32))").append(_BR_)    
        .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)   
        .append(_FOUR_).append("}").append(_BR_)
        .append(_FOUR_).append("return true;").append(_BR_)
        .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 是否不为空 */
    public static String isNotEmpty()
    {
        return new StringBuilder()
        .append("function ").append(IS_NOT_EMPTY).append("(value)").append(_BR_)
        .append("{").append(_BR_)
        .append(_FOUR_).append("if (value == null || value == '' || value.length < 1)").append(_BR_)
        .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
        .append(_BR_)
        .append(_FOUR_).append("for (var i=0;i<value.length;i++)").append(_BR_)
        .append(_FOUR_).append("{").append(_BR_)
        .append(_FOUR_).append(_FOUR_).append("if (value.charAt(i) > String.fromCharCode(32))").append(_BR_)    
        .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)   
        .append(_FOUR_).append("}").append(_BR_)
        .append(_FOUR_).append("return false;").append(_BR_)
        .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 是否相等 */
    public static String isEqual()
    {
        return new StringBuilder()
            .append("function ").append(IS_EQUAL).append("(value1,value2)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value1 == null || value1 == '' || value1.length < 1)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (value1 == null || value1 == '' || value1.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value1 == value2)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 判断长度是否在该范围 */
    public static String isLen()
    {
        return new StringBuilder()
            .append("function ").append(IS_LEN).append("(value,min,max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value == null || value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (min == 0)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 判断(如双字节*2)长度是否在该范围*/
    public static String isByteLen()
    {
        return new StringBuilder()
            .append("function ").append(IS_BYTE_LEN).append("(value,min,max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value == null || value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (min == 0)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var byteLen = value.replace(/[^\\x00-\\xff]/g,\"xx\").length;").append(_BR_)
            .append(_FOUR_).append("if ( byteLen < min ||  byteLen > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 是否数字组成，且在范围内 */
    public static String isNumericLen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_NUMERIC_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(NUMERIC).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否整数，且值在范围内 */
    public static String isIntegerValue()
    {
        return new StringBuilder()
            .append("function ").append(IS_INTEGER_VALUE).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value === undefined || value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(INTEGER).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (parseInt(value) < min || parseInt(value) > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 是否字母或数字组成，且在范围内 */
    public static String isAlphaNumericLen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否字母或数字组成，且在范围内 */
    public static String isAlphaNumericULLen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_UL_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC_UL).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否字母或数字组成，字母开头且在指定范围内 */
    public static String isAlphaNumericPALen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_PA_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC_PA).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否字母,数字或下划线组成且在指定范围内 */
    public static String isAlphaNumericUlLen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_UL_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC_UL).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否字母,数字或点号组成且在指定范围内 */
    public static String isAlphaNumericDotLen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_DOT_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC_DOT).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否字母,数字或(.-_~四个非特殊URL字符)组成且在指定范围内 */
    public static String isAlphaNumericUrlLen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_URL_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC_URL).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 是否字母,数字或下划线组成，字母或下划线开头且在指定范围内 */
    public static String isAlphaNumericUlPALen()
    {
        StringBuilder strb = new StringBuilder()
            .append("function ").append(IS_ALPHA_NUMERIC_UL_PA_LEN).append("(value, min, max)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (min == 0 && (value == '' || value.length == 0))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var reg = /").append(ALPHA_NUMERIC_UL_PA).append("/;").append(_BR_)
            .append(_FOUR_).append("var flg = reg.test(value);").append(_BR_)
            .append(_FOUR_).append("if (!flg)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if (value.length < min || value.length > max)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
            .append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }

    /** 是否在该范围内 */
    public static String isScope(String scope)
    {
        return new StringBuilder()
            .append("function ").append(IS_SCOPE).append("(value)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value === undefined || value == '' || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_).append(_BR_)
        
            .append(_FOUR_).append("for (var i=0;i<value.length;i++)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var charValue = value.substring(i,i+1);").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var accord = \"").append(scope).append("\";").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (accord.indexOf(charValue) == -1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("return true;").append(_BR_)
        
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 是否form中select选中 */
    public static String isSelect()
    {
        return new StringBuilder()
            .append("function ").append(IS_SELECT).append("(form, field)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if(typeof(form[field].length)==\"number\")").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var len = form[field].length;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("for (var i=0;i<len;i++)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("if(form[field][i].selected)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("return form[field].selected;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 是否form中checked选中 */
    public static String isChecked()
    {
        return new StringBuilder()
            .append("function ").append(IS_CHECKED).append("(form, field)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if(typeof(form[field].length)==\"number\")").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var len = form[field].length;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("for (var i=0;i<len;i++)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("if(form[field][i].checked)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("return form[field].checked;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 左值是否大于等于右值 */
    public static String isGreaterEqualThen()
    {
        return new StringBuilder()
            .append("function ").append(IS_GREATER_EQUAL_THEN).append("(value1, value2)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value1 > value2 || value1 == value2)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 左值是否大于右值 */
    public static String isGreaterThen()
    {
        return new StringBuilder()
            .append("function ").append(IS_GREATER_THEN).append("(value1, value2)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value1 > value2)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 左值是否小于等于右值 */
    public static String isLessEqualThen()
    {
        return new StringBuilder()
            .append("function ").append(IS_LESS_EQUAL_THEN).append("(value1, value2)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value1 < value2 || value1 == value2)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /** 左值是否小于右值 */
    public static String isLessThen()
    {
        return new StringBuilder()
            .append("function ").append(IS_LESS_THEN).append("(value1, value2)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if (value1 < value2)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_).append(_BR_).toString();
    }
    
    /*************************************/
    //字符串扩展方法相关
    /*************************************/

    /** 是否字符串以str开头 */
    public static String startWith()
    {
        return new StringBuilder()
            .append("String.prototype.startWith=function(str)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if(str==null||str==\"\"||this.length==0||str.length>this.length)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if(this.substr(0,str.length)==str)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }

    /** 是否字符串以str结尾 */
    public static String endWith()
    {
        return new StringBuilder()
            .append("String.prototype.endWith=function(str)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("if(str==null||str==\"\"||this.length==0||str.length>this.length)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append(_FOUR_).append("if(this.substring(this.length-str.length)==str)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return true;").append(_BR_)
            .append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 去除左空格 */
    public static String ltrim()
    {
        StringBuilder strb = new StringBuilder();
        strb.append("function ").append("ltrim(value)").append(_BR_);
        strb.append("{").append(_BR_);
        strb.append(_FOUR_).append("var w_space = String.fromCharCode(32);").append(_BR_);
        strb.append(_FOUR_).append("var v_length = value.length;").append(_BR_);
        strb.append(_FOUR_).append("if(v_length < 1)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("return \"\"").append(_BR_);
        strb.append(_BR_);
        strb.append(_FOUR_).append("var strTemp = \"\";").append(_BR_);
        strb.append(_FOUR_).append("var iTemp = 0;").append(_BR_);
        strb.append(_FOUR_).append("while(iTemp < v_length)").append(_BR_);
        strb.append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("if(value.charAt(iTemp) != w_space)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("strTemp = value.substring(iTemp,v_length);").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("break;").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("iTemp = iTemp + 1;").append(_BR_);
        strb.append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append("return strTemp;").append(_BR_);
        strb.append("}").append(_BR_);
        return strb.toString();
    }
    
    /** 去除右空格 */
    public static String rtrim()
    {
        StringBuilder strb = new StringBuilder();
        strb.append("function ").append("rtrim(value)").append(_BR_);
        strb.append("{//去除右空格").append(_BR_);
        strb.append(_FOUR_).append("var w_space = String.fromCharCode(32);").append(_BR_);
        strb.append(_FOUR_).append("var v_length = value.length;").append(_BR_);
        strb.append(_FOUR_).append("if(v_length < 1)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("return \"\"").append(_BR_);
        strb.append(_BR_);
        strb.append(_FOUR_).append("var strTemp = \"\";").append(_BR_);
        strb.append(_FOUR_).append("var iTemp = 0;").append(_BR_);
        strb.append(_FOUR_).append("while(iTemp < v_length)").append(_BR_);
        strb.append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("if(value.charAt(iTemp) != w_space)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("strTemp = value.substring(iTemp,v_length);").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("break;").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("iTemp = iTemp + 1;").append(_BR_);
        strb.append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append("return strTemp;").append(_BR_);
        strb.append("}").append(_BR_);
        return strb.toString();
    }
    
    /** 去除两边空格 */
    public static String trim()
    {
        StringBuilder strb = new StringBuilder();
        strb.append("function ").append("trim(value)").append(_BR_);
        strb.append("{//去除两边空格").append(_BR_);
        strb.append(_FOUR_).append("var w_space = String.fromCharCode(32);").append(_BR_);
        strb.append(_FOUR_).append("var v_length = value.length;").append(_BR_);
        strb.append(_FOUR_).append("if(v_length < 1)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("return \"\"").append(_BR_);
        strb.append(_BR_);
        strb.append(_FOUR_).append("var strTemp = \"\";").append(_BR_);
        strb.append(_FOUR_).append("var iTemp = 0;").append(_BR_);
        strb.append(_FOUR_).append("while(iTemp < v_length)").append(_BR_);
        strb.append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("if(value.charAt(iTemp) != w_space)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("strTemp = value.substring(iTemp,v_length);").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("break;").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("iTemp = iTemp + 1;").append(_BR_);
        strb.append(_FOUR_).append("}").append(_BR_);
        strb.append(_BR_);
        strb.append(_FOUR_).append("v_length = strTemp.length;").append(_BR_);
        strb.append(_FOUR_).append("if(v_length < 1)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("return \"\"").append(_BR_);
        strb.append(_BR_);
        strb.append(_FOUR_).append("var strTemp2 = \"\";").append(_BR_);
        strb.append(_FOUR_).append("var iTemp2 = v_length;").append(_BR_);
        strb.append(_FOUR_).append("while(iTemp2 > 0)").append(_BR_);
        strb.append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("if(strTemp.charAt(iTemp2-1) != w_space)").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("{").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("strTemp2 = strTemp.substring(0,iTemp2);").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append(_FOUR_).append("break;").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("iTemp2 = iTemp2 + 1;").append(_BR_);
        strb.append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append("return strTemp2;").append(_BR_);
        strb.append("}").append(_BR_);
        return strb.toString();
    }
    
    /*************************************/
    //form表单相关
    /*************************************/

    /** 选中一个选项 */
    public static String doSelectBox()
    {
        return new StringBuilder()
            .append("function doSelectBox(boxName)").append(_BR_)
            .append("{//从Radio中读取选中的一项").append(_BR_)
            .append(_FOUR_).append("var obj = document.getElementsByName(boxName);").append(_BR_)
            .append(_FOUR_).append("for(var i=0;i<obj.length;i++)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(obj[i].checked) ").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return obj[i].value;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append("alert('请选择一个选项');").append(_BR_)
            .append(_FOUR_).append("return false;").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 清空表单 */
    public static String doClearForm()
    {
        return new StringBuilder()
            .append("function doClearForm(form)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("form.reset();").append(_BR_)
            .append(_FOUR_).append("var length = form.elements.length;").append(_BR_)
            .append(_FOUR_).append("for (var i=0;i<length;i++)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var element = form.elements[i];").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (element.type == \"text\" || element.type == \"textarea\")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("element.value = \"\";").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else if (element.type == \"select-one\")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("if (element.options.length > 0)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append(_FOUR_).append("element.options[0].selected = true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 验证按钮变灰 */
    public static String setFormButtonGray()
    {
        return new StringBuilder()
            .append("function setFormButtonGray(form)").append(_BR_)
            .append("{//验证按钮变灰").append(_BR_)
            .append(_FOUR_).append("for (var i=0;i<form.length;i++)").append(_BR_)
            .append(_FOUR_).append("{//提交后submit,reset为灰色").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var elem = form.elements[i];").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(elem.type.toLowerCase() != \"submit\" && elem.type.toLowerCase() != \"reset\")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("continue;").append(_BR_).append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (typeof elem.getAttribute === undefined)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem[\"disabled\"]=true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem.setAttribute(\"disabled\", true);").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_).append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 验证按钮恢复 */
    public static String setFormButtonResume()
    {
        return new StringBuilder()
            .append("function setFormButtonResume(param)").append(_BR_)
            .append("{//传入form表单对象或form索引号").append(_BR_)
            .append(_FOUR_).append("var form = (param instanceof HTMLFormElement)?param:document.forms[param];").append(_BR_)
            .append(_FOUR_).append("for (var i=0;i<form.length;i++)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var elem=form.elements[i];").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(elem.type.toLowerCase()!=\"submit\" && elem.type.toLowerCase()!=\"reset\")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("continue;").append(_BR_).append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (\"disabled\" in elem)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem[\"disabled\"]=false;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem.setAttribute(\"disabled\", false);").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 验证按钮变灰 */
    public static String setButtonGray()
    {
        return new StringBuilder()
            .append("function setFormButtonGray(form)").append(_BR_)
            .append("{//验证按钮变灰").append(_BR_)
            .append(_FOUR_).append("for (var i=0;i<form.length;i++)").append(_BR_)
            .append(_FOUR_).append("{//提交后submit,reset为灰色").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var elem = form.elements[i];").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(elem.type.toLowerCase() != \"submit\" && elem.type.toLowerCase() != \"reset\")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("continue;").append(_BR_).append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (typeof elem.getAttribute === undefined)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem[\"disabled\"]=true;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem.setAttribute(\"disabled\", true);").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_).append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 验证按钮恢复 */
    public static String setButtonResume()
    {
        return new StringBuilder()
            .append("function setFormButtonResume(param)").append(_BR_)
            .append("{//传入form表单对象或form索引号").append(_BR_)
            .append(_FOUR_).append("var form = (param instanceof HTMLFormElement)?param:document.forms[param];").append(_BR_)
            .append(_FOUR_).append("for (var i=0;i<form.length;i++)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("var elem=form.elements[i];").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(elem.type.toLowerCase()!=\"submit\" && elem.type.toLowerCase()!=\"reset\")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("continue;").append(_BR_).append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if (\"disabled\" in elem)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem[\"disabled\"]=false;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("elem.setAttribute(\"disabled\", false);").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /*************************************/
    //其他一些常用方法
    /*************************************/
    
    public static String toFen()
    {
        return new StringBuilder()
            .append("function toFen(value)").append(_BR_)
            .append("{//将元转换成分").append(_BR_)
            .append(_FOUR_).append("var reg = /^(\\d+).?(\\d{0,2})$/;").append(_BR_)
            .append(_FOUR_).append("var r = value.match(reg);").append(_BR_)
            .append(_FOUR_).append("if (r == null)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return -1;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (r[2] == null || r[2] == '')").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return parseInt(r[1]) * 100;").append(_BR_)
            .append(_FOUR_).append("else if (r[2].length == 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return parseInt(r[1]) * 100 + parseInt(r[2]) * 10;").append(_BR_)
            .append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return parseInt(r[1]) * 100 + parseInt(r[2]);").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    public static String doPriceKeyUp()
    {
        return new StringBuilder()
            .append("function doPriceKeyUp(element)").append(_BR_)
            .append("{//输入金额时进行控制").append(_BR_)
            .append(_FOUR_).append("var value = element.value;").append(_BR_)
            .append(_FOUR_).append("if (value == null || value.length < 1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return;").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var c = value.substr(value.length-1, 1);").append(_BR_)
            .append(_FOUR_).append("if (!(c=='0'||c=='1'||c=='2'||c=='3'||c=='4'||c=='5'||c=='6'||c=='7'||c=='8'||c=='9'||c=='.'))").append(_BR_)
            .append(_FOUR_).append("{//只允许输入数字和点号，不是即退格").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("element.value = value.substr(0, value.length-1);").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (c == '.' && value.indexOf(\".\") != value.length-1)").append(_BR_)
            .append(_FOUR_).append("{//当前输入是点号，如果前面有点号，则退格").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("element.value = value.substr(0, value.length-1);").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("while (value.length > 1 && value.charAt(0) == '0' && value.charAt(1) != '.')").append(_BR_)
            .append(_FOUR_).append("{//去除多余的前缀0").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("value = value.substr(1, value.length);").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("if (value.charAt(0) == '.')").append(_BR_)
            .append(_FOUR_).append("{//如果第一字符为点号，则前补0").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("value = \"0\"+value;").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("//小数后只保留最多两位，多余退格").append(_BR_)
            .append(_FOUR_).append("var ind = value.indexOf(\".\");").append(_BR_)
            .append(_FOUR_).append("if (ind != -1 && ind < value.length-2-1)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("element.value = value.substr(0, ind+2+1);").append(_BR_)
            .append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("element.value = value").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 输入框实时计算可输入数目 */
    public static String doCheckCounter(int len)
    {
        return new StringBuilder()
            .append("function doCheckCounter(checkId, remainId)").append(_BR_)
            .append("{").append(_BR_)
            .append(_FOUR_).append("var content = document.getElementById(checkId).value;").append(_BR_)
            .append(_FOUR_).append("if(content.length == 0)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("document.getElementById(remainId).innerHTML = \""+len+"\";").append(_BR_)
            .append(_BR_)
            .append(_FOUR_).append("var num = 0;//预期计数：中文2字节，英文1字节").append(_BR_)
            .append(_FOUR_).append("var temp = '';//临时字符串").append(_BR_)
            .append(_FOUR_).append("for(var i=0;i<content.length;i++)").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(content.charCodeAt(i) > 127)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("num += 2;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("else").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("num++;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("if(num > "+len+")").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("document.getElementById(checkId).value = temp;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("return;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("temp += content.charAt(i);").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("document.getElementById(remainId).innerHTML = \"\"+("+len+" - num);").append(_BR_)
            .append(_FOUR_).append("}").append(_BR_)
            .append("}").append(_BR_)
            .toString();
    }
    
    /** 获取当前为提交后submit,reset为灰色javascript */
    public static String getConfirm(String message)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!confirm(\"").append(message).append("\"))").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
    /** 获取当前为提交后submit,reset为灰色javascript */
    public static String getGraySubmit(boolean firefox)
    {
        StringBuilder strb = new StringBuilder();
        
        if (!firefox)
        {//非火狐直接变灰
            strb.append(_FOUR_).append("setFormButtonGray(form);").append(_BR_);
        }
        else
        {//火狐检查是否有F && Z.onload，否则回退没办法恢复
            strb.append(_FOUR_).append("if (Z && Z.onload)").append(_BR_)
                .append(_FOUR_).append("{//firefox要求F && Z.onload时才支持提交变灰和回退恢复").append(_BR_).append(_BR_)
                //变灰
                .append(_FOUR_).append(_FOUR_).append("setFormButtonGray(form);").append(_BR_)
                //回退
                .append(_FOUR_).append(_FOUR_).append("Z.onload(function(form){setFormButtonResume(form);}, form);").append(_BR_)
                .append(_FOUR_).append("}").append(_BR_).append(_BR_);
        }
        
        return strb.toString();
    }
    
    public static String getFormIndexTarget()
    {
        StringBuilder strb = new StringBuilder();
        
        strb.append(_FOUR_).append("if (form.target === \"fCallFrame\")").append(_BR_)
            .append(_FOUR_).append("{").append(_BR_);
        
        //1.组装frameTarget
        strb.append(_FOUR_).append(_FOUR_).append("if (!form.frameTarget)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("var frameTarget = document.createElement(\"input\");").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("frameTarget.name = \"frameTarget\";").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("frameTarget.type = \"hidden\";").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("form.appendChild(frameTarget);").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("form.frameTarget.value = \"frameTarget\";").append(_BR_)
            .append(_BR_);

        //2.组装formIndex
        strb.append(_FOUR_).append(_FOUR_).append("if (!form.formIndex)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("var formIndex = document.createElement(\"input\");").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("formIndex.name = \"formIndex\";").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("formIndex.type = \"hidden\";").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("form.appendChild(formIndex);").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("var ind = -1;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("for (var i=0;i<document.forms.length;i++)").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("if (form == document.forms[i])").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("{").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append(_FOUR_).append("ind = i;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append(_FOUR_).append("break;").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append(_FOUR_).append("}").append(_BR_)
            .append(_FOUR_).append(_FOUR_).append("}").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("form.formIndex.value = ind;").append(_BR_);
        
        strb.append(_FOUR_).append("}").append(_BR_).append(_BR_);
        return strb.toString();
    }
    
    /** 获取字段值的验证Script */
    public static String buildValidateScript(String name, String field, String alert, String elementId, boolean isFocus)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!").append(name).append("(form.").append(field).append(".value))").append(_BR_);
        strb.append(buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }
    
    /** 获取字段作为参数的验证Script */
    public static String buildValidateScriptField(String name, String field, String alert, String elementId, boolean isFocus)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!").append(name).append("(form, '").append(field).append("'))").append(_BR_);
        strb.append(buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }
    
    /** 获取字段值和指定比较值的验证Script */
    public static String buildValidateScriptValue(String name, String field, String alert, String elementId, boolean isFocus, String value)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!").append(name).append("(form.").append(field).append(".value, ").append(value).append("))").append(_BR_);
        strb.append(buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }
    
    /** 获取两个字段值比较的验证Script */
    public static String buildValidateScriptTwo(String name, String field, String field2, String alert, String elementId, boolean isFocus)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!").append(name).append("(form.").append(field).append(".value, form.").append(field2).append(".value))").append(_BR_);
        strb.append(buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }
    
    /** 获取字段值与指定大小值比较的验证Script */
    public static String buildValidateScriptMinMax(String name, String field, String alert, String elementId, boolean isFocus, int min, int max)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!").append(name).append("(form.").append(field).append(".value, ").append(min).append(", ").append(max).append("))").append(_BR_);
        strb.append(buildValidateScriptInner(field, alert, elementId, isFocus));
        return strb.toString();
    }
    
    /** 判断内部的内容，从{开始，至}结束 */
    private static String buildValidateScriptInner(String field, String alert, String elementId, boolean isFocus)
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("{").append(_BR_);
        if (elementId == null)
            strb.append(_FOUR_).append(_FOUR_).append("(Z || window).failure('").append(alert).append("');").append(_BR_);
        else
            strb.append(_FOUR_).append(_FOUR_).append("document.getElementById(\"").append(elementId).append("\").innerHTML='").append(alert).append("';").append(_BR_);
        if (isFocus)
            strb.append(_FOUR_).append(_FOUR_).append("form.").append(field).append(".focus();").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_);
        strb.append(_FOUR_).append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
}
