/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.util;

import java.util.Map;
import java.util.Map.Entry;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Urls;

/**
 * 对HttpRequest进行一级封装，实现相关的数据提取工具类，分隔HttpRequest代码
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Requests")
public class Requests implements ZmlContextConstants
{
    /**
     * 提取所有参数及其值,并以隐藏控件的方式打出
     */
    public static String printAllParameterInHidden(HttpRequest request)
    {
        StringBuilder strb = new StringBuilder();

        Map<String, String> paramMap = request.getParameterMap();
        for (Entry<String, String> entry : paramMap.entrySet())
        {
            String name = entry.getKey();
            String[] values = Arrays.toStringArray(entry.getValue());
            for (String value : values)
            {//字符串转化为数组
                strb.append("<input type=\"hidden\"").append(" name=\"").append(name).append("\"").append(" value=\"").append(value).append("\">\n");
            }
        }

        return strb.toString();
    }

    /**
     * 提取所有参数,并以URL的方式出现
     */
    public static String getParameterForURL(HttpRequest request)
    {
        if (request.getParameterMap().isEmpty())
            return "";
        
        StringBuilder strb = new StringBuilder("?");
        for (Entry<String, String> entry : request.getParameterMap().entrySet())
        {
            strb.append(entry.getKey()).append("=").append(Urls.encodeUTF8(entry.getValue())).append("&");
        }
        strb.setLength(strb.length()-1);
        return strb.toString();
    }
}