/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

/**
 * HTTP连接信息类，包括输入输出流，实现Runnable，用于线程处理
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public final class HttpNioSslConnection extends HttpNioConnection
{
    private SSLEngine sslEngine;
    private HttpNioSslBuffer buffer;
    
    public HttpNioSslConnection(HttpNioSslListener listener, SocketChannel channel, InetAddress remoteAddress, SSLEngine sslEngine)
    {//HTTPS
        super(listener, channel, remoteAddress);
        
        this.sslEngine = sslEngine;
        this.buffer = new HttpNioSslBuffer(sslEngine);
    }
    
    public SSLEngine getSSLEngine()
    {
        return sslEngine;
    }
    
    /****************************************************************************/
    //SSL读数据握手&关闭
    /****************************************************************************/
    
    @Override /** 关闭后置，SSL连接重写 */
    protected void closeAfter()
    {
        if (sslEngine != null)
        {//关闭SSL引擎
            sslEngine.closeOutbound();
            try{sslEngine.closeInbound();}catch (SSLException e){}
            sslEngine = null;
        }
    }
    
    /*******************************************************************************************/
    //重写方法，1）读包后解包处理，2）写入数据方法并封包处理，3）关联websocket
    /*******************************************************************************************/
    
    @Override /** 判断消息头，SSL连接可重写 */
    protected void chkHeader()
    {
        if (header == null || header.isParsed())
            header = new HttpNioHeader(this, sslEngine);
    }
    
    @Override /** 解决缓冲数据，SSL连接可重写 */
    protected int parseBuffer()
    {
        return buffer.parseBuffer(netBuf, header.getInputStream());
    }
    
    @Override /** 写入数据并封包处理 */
    public void write(byte[] data, int off, int len) throws IOException
    {
        ByteBuffer appBuf = ByteBuffer.wrap(data);
        ByteBuffer netBuf = ByteBuffer.allocate(sslEngine.getSession().getPacketBufferSize());
        while (appBuf.hasRemaining())
        {
            netBuf.clear();
            sslEngine.wrap(appBuf, netBuf);
            netBuf.flip();
            
            //写入到通道
            super.write(netBuf);
        }
    }
    
    @Override
    public String toString()
    {
        return new StringBuilder("HttpNioSslConnection[").append(connId).append("]").toString();
    }
}
