/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.entities;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.constants.HttpMimeType;

import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Urls;

/**
 * CLASS资源处理器 <br>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ClassResourceEntity implements HttpEntity
{     
    @Override
    public boolean isMatch(String pathInContext)
    {//全匹配，在handle中处理
        return true;
    }
    
    @Override
    public void handle(HttpHeader header, HttpSender sender) throws IOException
    {
        HttpContext context = header.getContext();
        String filePath = header.getPathOnResource();
        if (filePath == null)
        {
            filePath = context.getResourcePath() + header.getPathInContext();
            filePath = Urls.decode(filePath, header.getCharacterEncoding());
        }
        
        if (filePath.indexOf(".") == -1)
        {//暂不支持无后缀的文件类型,同时也不支持目录列表
            context.getNotFoundHandler().handle(header, sender);
            return;
        }
        
        URL url = Resources.getResource(ClassResourceEntity.class, filePath);
        if (url == null)
        {//未找到直接返回404
            context.getNotFoundHandler().handle(header, sender);
            return;
        }
        
        URLConnection conn = url.openConnection();
        long lastModified = conn.getLastModified();
        String lastModifiedTime = DateTimes.getDateTimeHttp(lastModified);
        
        String ifModifiedSince = header.getHeader(_IF_MODIFIED_SINCE_);
        if (ifModifiedSince != null && ifModifiedSince.indexOf(lastModifiedTime) != -1)
        {//如果有要求未修改返回304
            sender.setHeader(_CACHE_CONTROL_, _MAX_AGE_+"="+context.getExpires());
            sender.sendError(_304_NOT_MODIFIED_);
            return;
        }
        
        //找到则设置响应属性
        String fileExt = Files.getFileExt(filePath);
        String mimeType = header.getMimeType();
        if (mimeType == null)
            mimeType = HttpMimeType.getResourceMimeType(fileExt);

        if (_TEXT_HTML_.equals(mimeType))
            sender.setContentType(_TEXT_HTML_+"; charset="+header.getCharacterEncoding());
        else
            sender.setContentType(mimeType);
        
        //设置响应内容属性
        sender.setHeader(_ACCEPT_RANGES_, _BYTES_);
        sender.setHeader(_LAST_MODIFIED_, lastModifiedTime);
        
        if (header.isMethodResponseContent())
        {//GET,POST
            sender.setHeader(_CACHE_CONTROL_, _MAX_AGE_+"="+context.getExpires());
            sender.setHeader(_CONTENT_LENGTH_, conn.getContentLengthLong());
            try(InputStream in = conn.getInputStream())
            {
                Streams.putBytes(in, sender.getOutputStream());
            }
        }
        
        sender.commit();
    }
}
