/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.service;

import java.io.IOException;

import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

/**
 * Ajax服务，提供给页面调用，验证方式如下：
 * 1.连接提供当页面地址且在ZAction中能找到，格式如：/service/ajax?path=window.location.pathname
 * 2.必须有会话，且会话不是首次创建。
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 * @version v1.3.0 @author zouzhigang 2017-3-15 增加对表单方式的提交
 */
public class AjaxService implements HttpExecutor, ZmlContextConstants
{
    @Override
    public boolean isMatch(String pathInContext)
    {
        return _PATH_SERVICE_AJAX_.equals(pathInContext);
    }
    
    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException
    {
        if (!request.isXMLHttpRequest() || !_POST_.equals(request.getMethod()) || 
            !(_TEXT_PLAIN_.equals(request.getMimeType()) || _APPLICATION_X_WWW_FORM_.equals(request.getMimeType())) || 
            !_UTF_8_.equalsIgnoreCase(request.getCharacterEncodingHeader()))
        {//要求XMLHttpRequest/POST/text/plain/UTF-8的访问
            response.sendError(_403_FORBIDDEN_);
            return;
        }
        
        String path = request.getParameterOnURL(ZC_PATH);
        String serviceId = Strings.trim(request.getHeader(_X_RMI_SERVICE_), "");
        String clazz = Strings.trim(request.getHeader(_X_RMI_CLASS_), "");
        String method = request.getHeader(_X_RMI_METHOD_);
        if (Validates.isEmptyBlank(path) || (Validates.isEmptyBlank(clazz) && Validates.isEmptyBlank(serviceId)) || Validates.isEmptyBlank(method))
        {//必须指定访问路径，类和方法名，否则认为是非法请求
            response.sendError(_412_PRECONDITION_FAILED_);
            return;
        }
        
        RmiService service = ((Context)request.getContext()).getServiceExecutor().getRmiService();
        
        String classNameId = Validates.isEmpty(clazz)?serviceId:clazz;
        String interceptors = request.getContextAttributeString(_SERV_AJAX_INTERCEPTOR_);
        if (!service.chkInterceptor(request, response, interceptors, classNameId, method))
        {//如果有配置缺省拦截器时，有错误或认证失败不再继续
            return;
        }
        
        //最后由RMI服务处理
        service.service(request, response);
    }
}
