/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.rule;

import org.zhiqim.httpd.HttpRequest;

/**
 * 定义替换权限接口，通过请求和指定参数验证，成功返回要求的URL，否则返回验证权限URL，举例:
 * <a href="${ChkPermissionRule.replace(request, "delete", "/delete.htm")}"><button type="button" class="blue">删除</button></a></#if>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface ReplacePermissionRule
{
    /**
     * 替换权限接口定义，当参数验证未通过则返回指定的URL
     * 
     * @param request       请求的上下文环境
     * @param permission    请求权限参数信息
     * @param url           请求的URL信息
     * @return              检验之后的有效信息
     * @throws Exception    可能的异常
     */
    public String replace(HttpRequest request, String permission, String url) throws Exception;
}
