/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.extend;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;


/**
 * 用于配置验证表单的Action 
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class ValidateAction implements Action
{
    /** 置execute为final，防止子类重写 */
    public final void execute(HttpRequest request) throws Exception 
    {
        //先执行validate，设置验证列表
        validate(request);
        
        //判断验证列表，如果有问题直接返回
        if (!request.chkValidate())
        {
            request.returnHistory();
            return;
        }
            
        //清除验证，由子类实现业务和一些与业务相关的验证
        request.clearValidate();
        perform(request);
    }
    
    /** 由子类继承,初始化验证列表 */
    protected abstract void validate(HttpRequest request) throws Exception; 
    
    /** 由子类继承,子类实现业务，类似于Action的execute */
    protected abstract void perform(HttpRequest request) throws Exception; 
}
