/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.extend;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;

import org.zhiqim.kernel.util.Validates;

/**
 * 提供通过GET和POST请求分开处理，常用于FORM提交
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class GetPostAction implements Action
{
    /** 设置为final，防止子类重写 */
    public final void execute(HttpRequest request) throws Exception
    {
        if (request.isMethodGet())
        {
            //设置浏览器私有缓存表单信息，保证回退时填充表单
            request.setResponsePrivateCache();
            request.setAlertMsg(null);

            //写入验证信息
            validate(request);
            
            //调用子类实现的doGet方式
            doGet(request);
            
            //优先view
            if (!Validates.isEmptyBlank(request.getView()))
                request.setView(request.getView(), request.getInclude());
        }
        else if (request.isMethodPost())
        {
            //先执行validateForm，取得验证
            validate(request);
            
            //判断验证列表，如果有问题直接返回上一页
            if (!request.chkValidate())
            {
                request.returnHistory();
                return ;
            }
            
            //清除验证并处理
            request.clearValidate();
            doPost(request);
            
            //POST优先redirect
            if (!Validates.isEmptyBlank(request.getRedirectInner()))
                request.setRedirectInner(request.getRedirectInner());
        }
    }

    /** 初始化验证列表 */
    protected abstract void validate(HttpRequest request) throws Exception; 
    
    /** doGet方法，由子类实现 */
    protected abstract void doGet(HttpRequest request) throws Exception;
    
    /** doPost方法，由子类实现 */
    protected abstract void doPost(HttpRequest request) throws Exception;

}
