/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.extend;

import java.lang.reflect.Method;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;


/**
 * 按子类方法(根据参数选择)的xxx.do?method=add分发器,不提供表单检查,由方法体自行检查<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class DispatchAction implements Action
{
    /** 按指定的method参数值方法 来分发 */
    public final void execute(HttpRequest request) throws Exception
    {
        String method = request.getParameter(ZC_METHOD);
        if(method == null)
        {
            request.returnHistory("未找到分发的方法名");
            return;
        }
        
        Method m = getClass().getMethod(method, HttpRequest.class);
        if (m == null)
        {
            request.returnHistory("未找到分发["+method+"]的方法");
            return;
        }
        
        m.invoke(this, request);
    }
}
