/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.config;

import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;

import org.zhiqim.kernel.control.Filter;
import org.zhiqim.kernel.control.FilterEndsWith;
import org.zhiqim.kernel.control.FilterHandler;
import org.zhiqim.kernel.util.Resources;

/**
 * ActionPackage配置
 *
 * @version v1.0.0 @author zhichenggang 2016-12-31 新建与整理
 */
public class ZActionPackage implements ZmlContextConstants
{
    private final ZmlConfig zmlConfig;
    
    private final String actionPackage;
    private final ZActionMap actionMap;
    
    public ZActionPackage(ZmlConfig zmlConfig, ZConfig config, String actionPackage)
    {
        this.zmlConfig = zmlConfig;
        this.actionPackage = actionPackage;
        this.actionMap = new ZActionMap(zmlConfig, config);
    }
    
    public void load()
    {
        Filter filter = new FilterEndsWith().param(".class");
        FilterHandler handler = new ZActionPackageLoader(this);
        //扫描全路径
        Resources.scanClassPath(filter, handler);
    }

    public String getActionPackage()
    {
        return actionPackage;
    }

    public void addActionOnPackage(ZAction action)
    {
        actionMap.addAction(action);
    }

    public ZmlConfig getConfig()
    {
        return zmlConfig;
    }
    
    /*****************************************************************************/
    //通过path 获取 ZAction
    /*****************************************************************************/
    
    public ZAction getInTurnAction(String path)
    {
        //先查本文件精确再查模糊匹配
        ZAction action = actionMap.getExactAction(path);
        if (action != null)
            return action;
        
        return actionMap.getFuzzyAction(path);
    }
    
    public ZAction getExactAction(String path)
    {
        return actionMap.getExactAction(path);
    }
    
    public ZAction getFuzzyAction(String path)
    {
        return actionMap.getFuzzyAction(path);
    }
    
    /*****************************************************************************/
    //通过class 获取 ZAction
    /*****************************************************************************/
    
    public ZAction getInTurnActionByClass(String clazz)
    {
        //先查本文件精确再查模糊匹配
        ZAction action = actionMap.getExactActionByClass(clazz);
        if (action != null)
            return action;
        
        return actionMap.getFuzzyActionByClass(clazz);
    }
    
    public ZAction getExactActionByClass(String clazz)
    {
        return actionMap.getExactActionByClass(clazz);
    }
    
    public ZAction getFuzzyActionByClass(String clazz)
    {
        return actionMap.getFuzzyActionByClass(clazz);
    }
}
