/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.config;

import java.util.List;

import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.core.Interceptor;

import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

/**
 * Action配置类，支持四种格式<br><br>
 * 
 * 1、纯Action，<action name="首页" path="/index.htm" class="org.zhiqim.httpd.console.IndexAction"/>表示访问path时，由Action返回内容，不加载view，也不重定向
 * 2、纯视图Action，<action name="首页" path="/index.htm" view="/zml/index.zml"/>表示访问path时使用默认Action[org.zhiqim.foxcontent.extend.EmptyAction]加载view返回响应<br>
 * 3、模型Action，<action name="首页" path="/index.htm" view="/zml/index.zml" class="org.zhiqim.httpd.console.IndexAction"/>
 * 4、重定向Action，<action name="首页" path="/index.htm" redirect="/index2.htm" class="org.zhiqim.httpd.console.IndexAction"/>
 * 
 * @see Action      对应的一个Action
 * @see Interceptor Action支持设置拦截器，如<action name="登录" path="/index2.htm" interceptor="chkLogin" view="/zml/index2.zml" class="org.zhiqim.httpd.console.Index2Action"/>
 * 
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ZAction implements ZmlContextConstants
{
    private ZConfig config;
    
    private String name;                                //模型名
    private String path;                                //PATH名称
    
    private String interceptor;                         //请求的拦截器数组
    private String transaction;                         //请求的事务
    
    private String forward;                             //内部转发新的地址
    private String redirect;                            //重定向新的地址
    private String view;                                //加载视图地址
    private String include;                             //加载视图内部包含的地址
    
    private String clazz;                               //Action子类
    private String method;                              //使用StdAction的方法
    private String success;                             //转向页定制的对话框提示信息
    private String tips;                                //转向页定制的冒泡提示信息
    
    private transient List<String> matchList;           //匹配的参数列表，临时属性，当/*/*.htm有效
    
    public String toString()
    {
        StringBuilder strb = new StringBuilder("<action");
        strb.append(" name=").append(_DOUBLE_QUOTE_).append(name).append(_DOUBLE_QUOTE_);
        strb.append(" path=").append(_DOUBLE_QUOTE_).append(path).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(transaction))
            strb.append(" transaction=").append(_DOUBLE_QUOTE_).append(interceptor).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(interceptor))
            strb.append(" interceptor=").append(_DOUBLE_QUOTE_).append(interceptor).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(forward))
            strb.append(" forward=").append(_DOUBLE_QUOTE_).append(forward).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(redirect))
            strb.append(" redirect=").append(_DOUBLE_QUOTE_).append(redirect).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(view))
            strb.append(" view=").append(_DOUBLE_QUOTE_).append(view).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(include))
            strb.append(" include=").append(_DOUBLE_QUOTE_).append(include).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(clazz))
            strb.append(" class=").append(_DOUBLE_QUOTE_).append(clazz).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(method))
            strb.append(" method=").append(_DOUBLE_QUOTE_).append(method).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(success))
            strb.append(" success=").append(_DOUBLE_QUOTE_).append(success).append(_DOUBLE_QUOTE_);
        
        if (!Validates.isEmpty(tips))
            strb.append(" tips=").append(_DOUBLE_QUOTE_).append(success).append(_DOUBLE_QUOTE_);
        
        return strb.append(" />").toString();
    }
    
    /** 获取类名，如果为空则取EmptyAction */
    public String getClassName()
    {
        return clazz == null?ZC_EMPTY_ACTION_NAME:clazz;
    }
    
    /***************************************************************/
    //设置属性，统一对字段进行trim
    /***************************************************************/
    
    public void setConfig(ZConfig config)
    {
        this.config = config;
    }
    
    public void setName(String name)
    {
        this.name = name;
    }
    
    public ZAction setPath(String path)
    {
        this.path = Strings.trim(path);
        return this;
    }
    
    public void setInterceptor(String interceptor)
    {
        this.interceptor = Strings.trim(interceptor);
    }

    public void setTransaction(String transaction)
    {
        this.transaction = transaction;
    }

    public void setView(String view)
    {
        this.view = Strings.trim(view);
    }
    
    public void setInclude(String include)
    {
        this.include = Strings.trim(include);
    }

    public void setForward(String forward)
    {
        this.forward = Strings.trim(forward);
    }
    
    public void setRedirect(String redirect)
    {
        this.redirect = Strings.trim(redirect);
    }
    
    public void setClazz(String clazz)
    {
        this.clazz = Strings.trim(clazz);
    }
    
    public void setMethod(String method)
    {
        this.method = Strings.trim(method);
    }

    public void setSuccess(String success)
    {
        this.success = Strings.trim(success);
    }
    
    public void setTips(String tips)
    {
        this.tips = Strings.trim(tips);
    }
    
    public ZAction setMatchList(List<String> matchList)
    {
        this.matchList = matchList;
        return this;
    }
    
    /***************************************************************/
    //获取属性
    /***************************************************************/
    
    public ZConfig getConfig()
    {
        return config;
    }
    
    public String getName()
    {
        return name;
    }
    
    public String getPath()
    {
        return path;
    }
    
    public String getInterceptor()
    {
        return interceptor;
    }
    
    public String getTransaction()
    {
        return transaction;
    }
    
    public String getView()
    {
        return view;
    }
    
    public String getInclude()
    {
        return include;
    }

    public String getForward()
    {
        return forward;
    }
    
    public String getRedirect()
    {
        return redirect;
    }
    
    public String getClazz()
    {
        return clazz;
    }
    
    public String getMethod()
    {
        return method;
    }
    
    public String getSuccess()
    {
        return success;
    }
    
    public String getTips()
    {
        return tips;
    }
    
    public List<String> getMatchList()
    {
        return matchList;
    }
}
