/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 拦截器注解定义
 * 
 * 1.可以在类上定义，表示该类所有的方法执行时都检查拦截器
 * 2.可以在类的方法上定义，表示除类上的拦截器外，方法还有自己的拦截器也要检查
 * 3.@see @AnInterceptNot 表示在类上的拦截器上，要排除定义的拦截器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AnIntercept 
{
    /** 拦截器名称数组 */
    String[] value();
}
