/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Context;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Strings;

/**
 * HttpContext引导类，为初始化类，允许子类实现，每context根据自身要求初始化和释放对象
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ZmlBootstrap
{
    protected static Log log = LogFactory.getLog(ZmlBootstrap.class);
    protected Context context;
    
    private boolean isBefore;
    private boolean isAfter;
    private volatile boolean isClosed;
    
    /** 设置上下文环境 */
    public final void setContext(Context context)
    {
        if (this.context != null)
            return;
        
        this.context = context;
    }
    
    /** 获取上下文环境 */
    public final Context getContext()
    {
        return context;
    }
    
    /***************************************************************************/
    //解决多依赖关系下一个组件的引导类只能引导一次
    /***************************************************************************/
    
    /** 是否已前部引导 */
    public final boolean isBefore()
    {
        return isBefore;
    }

    /** 设置是否前部引导 */
    public final void setBefored()
    {
        this.isBefore = true;
    }
    
    /** 是否已后部引导 */
    public final boolean isAfter()
    {
        return isAfter;
    }

    /** 设置是否已后部引导 */
    public final void setAftered()
    {
        this.isAfter = true;
    }

    /** 是否已销毁 */
    public final boolean isClosed()
    {
        return isClosed;
    }
    
    /** 关闭引导，子类实现释放资源接口 */
    public final void close()
    {
        if (!isClosed)
            return;
        
        isClosed = true;
        try{destroy();}catch(Throwable e){}
    }
    
    /***************************************************************************/
    //子类可重写的三个受保护方法
    /***************************************************************************/
    
    /** 在配置加载之后,在ZML配置之前 */
    protected void initBefore() throws Exception
    {
    }
    
    /** 在配置加载之后,在ZML配置之后 */
    protected void initAfter() throws Exception
    {
    }

    /** 释放资源接口，注:如果在init方法内初始化了线程等应用,务必在这里释放 */
    protected void destroy()
    {
    }
    
    /***************************************************************************/
    //子类可重写的两个日志公开方法
    /***************************************************************************/
    
    /**
     * 日志输出接口
     * 
     * @param request   请求
     * @param message   消息
     */
    public void log(HttpRequest request, String message)
    {
        log(request, message, null);
    }
    
    /**
     * 日志输出接口
     * 
     * @param request   请求
     * @param message   消息
     * @param e         访问时产生的异常
     */
    public void log(HttpRequest request, String message, Throwable e)
    {
        String sessionName = Strings.toString(request.getSessionName(), Strings.toString(request.getRequestName(), "guest"));
        StringBuilder strb = new StringBuilder()
            .append("USER:").append(sessionName).append(" ")
            .append("IP:").append(request.getRemoteAddr()).append(" ")
            .append("URI:").append(request.getRequestURI());
        
        if (message != null)
            strb.append(" ").append(message);
            
        if (e == null)
            log.info(strb.toString());
        else
            log.error(strb.toString(), e);
    }
}
