/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context;

import java.io.IOException;

import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.kernel.util.Validates;

/**
 * 资源处理器，/zres/*和/ztmpl/*下除/ztmpl/*.htm,ztmpl/*.zml的资源访问
 *
 * @version v1.0.0 @author zouzhigang 2017-12-22 新建与整理
 */
public class ZResExecutor implements HttpExecutor, ZmlContextConstants
{
    @Override
    public boolean isMatch(String pathInContext)
    {
        return Validates.isMatch(pathInContext, ZC_RES_ZRES_FILE) || Validates.isMatch(pathInContext, ZC_RES_ZTMPT_FILE);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException
    {
        request.getContext().handleResource(request, response);
    }
}
