/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.constants;

import java.util.HashMap;

import org.zhiqim.httpd.HttpdConstants;


/**
 * HTTP状态码常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpStatus implements HttpdConstants
{
    private static final HashMap<Integer, String> _statusMsg = new HashMap<Integer, String>();
    
    static
    {
        _statusMsg.put(_0_SUCCESS_,                             _0_DESC_);
        _statusMsg.put(_100_CONTINUE_,                          _100_DESC_);
        _statusMsg.put(_101_SWITCHING_PROTOCOLS_,               _101_DESC_);
        _statusMsg.put(_102_PROCESSING_,                        _102_DESC_);
        
        _statusMsg.put(_200_OK_,                                _200_DESC_);
        _statusMsg.put(_201_CREATED_,                           _201_DESC_);
        _statusMsg.put(_202_ACCEPTED_,                          _202_DESC_);
        _statusMsg.put(_203_NON_AUTHORITATIVE_INFORMATION_,     _203_DESC_);
        _statusMsg.put(_204_NO_CONTENT_,                        _204_DESC_);
        _statusMsg.put(_205_RESET_CONTENT_,                     _205_DESC_);
        _statusMsg.put(_206_PARTIAL_CONTENT_,                   _206_DESC_);
        _statusMsg.put(_207_MULTI_STATUS_,                      _207_DESC_);
        
        _statusMsg.put(_300_MULTIPLE_CHOICES_,                  _300_DESC_);
        _statusMsg.put(_301_MOVED_PERMANENTLY_,                 _301_DESC_);
        _statusMsg.put(_302_FOUND_,                             _302_DESC_);
        _statusMsg.put(_303_SEE_OTHER_,                         _303_DESC_);
        _statusMsg.put(_304_NOT_MODIFIED_,                      _304_DESC_);
        _statusMsg.put(_305_USE_PROXY_,                         _305_DESC_);
        _statusMsg.put(_306_SWITCH_PROXY_,                      _306_DESC_);
        _statusMsg.put(_307_TEMPORARY_REDIRECT_,                _307_DESC_);
        
        _statusMsg.put(_400_BAD_REQUEST_,                       _400_DESC_);
        _statusMsg.put(_401_UNAUTHORIZED_,                      _401_DESC_);
        _statusMsg.put(_402_PAYMENT_REQUIRED_,                  _402_DESC_);
        _statusMsg.put(_403_FORBIDDEN_,                         _403_DESC_);
        _statusMsg.put(_404_NOT_FOUND_,                         _404_DESC_);
        _statusMsg.put(_405_METHOD_NOT_ALLOWD_,                 _405_DESC_);
        _statusMsg.put(_406_NOT_ACCEPTABLE_,                    _406_DESC_);
        _statusMsg.put(_407_PROXY_AUTHENTICATION_REQUIRED_,     _407_DESC_);
        _statusMsg.put(_408_REQUEST_TIMEOUT_,                   _408_DESC_);
        _statusMsg.put(_409_CONFLICT_,                          _409_DESC_);
        _statusMsg.put(_410_GONE_,                              _410_DESC_);
        _statusMsg.put(_411_LENGTH_REQUIRED_,                   _411_DESC_);
        _statusMsg.put(_412_PRECONDITION_FAILED_,               _412_DESC_);
        _statusMsg.put(_413_REQUEST_ENTITY_TOO_LARGE_,          _413_DESC_);
        _statusMsg.put(_414_REQUEST_URL_TOO_LARGE_,             _414_DESC_);
        _statusMsg.put(_415_UNSUPPORTED_MEDIA_TYPE_,            _415_DESC_);
        _statusMsg.put(_416_REQUESTED_RANGE_NOT_SATISFIABLE_,   _416_DESC_);
        _statusMsg.put(_417_EXPECTATION_FAILED_,                _417_DESC_);
        _statusMsg.put(_421_TOO_MANY_CONNECTIONS_FROM_IP_,      _421_DESC_);
        _statusMsg.put(_422_UNPROCESSABLE_ENTITY_,              _422_DESC_);
        _statusMsg.put(_423_LOCKED_,                            _423_DESC_);
        _statusMsg.put(_424_FAILED_DEPENDENCY_,                 _424_DESC_);
        _statusMsg.put(_425_UNORDERED_COLLECTION_,              _425_DESC_);
        _statusMsg.put(_426_UPGRADE_REQUIRED_,                  _426_DESC_);
        _statusMsg.put(_444_INTERRUPT_,                         _444_DESC_);
        _statusMsg.put(_449_RETRY_WITH_,                        _449_DESC_);
        
        _statusMsg.put(_500_INTERNAL_SERVER_ERROR_,             _500_DESC_);
        _statusMsg.put(_501_NOT_IMPLEMENTED_,                   _501_DESC_);
        _statusMsg.put(_502_BAD_GATEWAY_,                       _502_DESC_);
        _statusMsg.put(_503_SERVER_UNAVAILABLE_,                _503_DESC_);
        _statusMsg.put(_504_GATEWAY_TIMEOUT_,                   _504_DESC_);
        _statusMsg.put(_505_VERSION_NOT_SUPPORTED_,             _505_DESC_);
        _statusMsg.put(_506_VARIANT_ALSO_NEGOTIATES_,           _506_DESC_);
        _statusMsg.put(_507_INSUFFICIENT_STORAGE_,              _507_DESC_);
        _statusMsg.put(_508_LOOP_DETECTED_,                     _508_DESC_);
        _statusMsg.put(_509_BANDWIDTH_LIMIT_EXCEEDED_,          _509_DESC_);
        _statusMsg.put(_510_NOT_EXTENDED_,                      _510_DESC_);
        _statusMsg.put(_600_UNPARSEABLE_RESPONSE_HEADERS_,      _600_DESC_);
        
        _statusMsg.put(_601_REDIRECT_PARENT_,                   _601_DESC_);
        _statusMsg.put(_602_REDIRECT_,                          _602_DESC_);
        _statusMsg.put(_603_REDIRECT_TOP_,                      _603_DESC_);
        _statusMsg.put(_611_IP_NOT_ALLOW_,                      _611_DESC_);
        _statusMsg.put(_612_SIGNATURE_FAILED_,                  _612_DESC_);
        _statusMsg.put(_621_INTERCEPTOR_NOT_EXIST_,             _621_DESC_);
        _statusMsg.put(_622_INTERCEPTED_,                       _622_DESC_);
        _statusMsg.put(_623_INTERCEPTOR_EXCEPTION_,             _623_DESC_);
    }
    
    public static final String getStatusMsg(int code)
    {
        String desc = _statusMsg.get(code);
        return desc==null?""+code:desc;
    }
}
