/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.bio;

import java.net.SocketTimeoutException;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpWebsocketConnectionAbs;
import org.zhiqim.httpd.HttpWebsocketMessage;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.seqs.Sequence;

/**
 * HttpWebsocket连接线程
 *
 * @version v1.0.0 @author zouzhigang 2017-6-9 新建与整理
 */
public class HttpBioWebsocketConnection extends HttpWebsocketConnectionAbs implements Runnable
{
    private static final Sequence sequence = new Sequence();
    
    private HttpBioConnection conn;
    private Thread thread;
    
    public HttpBioWebsocketConnection(HttpBioConnection conn, HttpContext context, String protocol, String sessionId)
    {
        super(context, protocol, sessionId);
        
        this.conn = conn;
    }
    
    public HttpBioConnection getConnection()
    {
        return conn;
    }
    
    /***********************************************************************************/
    //打开&关闭
    /***********************************************************************************/
    
    public synchronized void open()
    {
        thread = Threads.newThread(this, "Http.Websocket", sequence);
        thread.start();
        
        while (!isRunning)
        {//阻塞等待线程运行成功
            Threads.sleepIgnoreException(3);
        }
    }
    
    public synchronized void close()
    {
        if (!isRunning)
            return;
        
        //1.置关闭标志
        isRunning = false;
        
        //2.关闭监听线程
        if (thread != null)
        {
            if (!thread.isInterrupted())
                thread.interrupt();
            
            thread = null;
        }
        
        //3.关闭通讯
        super.close();
    }
    
    public synchronized void exception(Throwable e)
    {
        if (!isRunning)
            return;
        
        //1.置关闭标志
        isRunning = false;
        
        //2.关闭监听线程
        if (thread != null)
        {
            if (!thread.isInterrupted())
                thread.interrupt();
            
            thread = null;
        }
        
        //3.关闭连接
        if (conn != null)
        {
            conn.close();
            conn = null;
        }
        
        //4.关闭通讯
        super.exception(e);
    }
    
    /***********************************************************************************/
    //线程监听接受数据
    /***********************************************************************************/
    
    @Override
    public void run()
    {
        isRunning = true;
        while (isRunning)
        {
            try
            {
                HttpWebsocketMessage data = new HttpWebsocketMessage().parse(conn.getInputStream());
                if (data.isPong())
                {//心跳响应
                    continue;
                }
                
                if (data.isPing())
                {//心跳请求
                    HttpWebsocketMessage message = new HttpWebsocketMessage().buildPong();
                    send(message.toBytes());
                    continue;
                }
                
                if (data.isClose())
                {//接收到退出
                    close();
                    return;
                }
                
                if (data.isText())
                {//接收到消息
                    context.getSessionManager().updateLastAccessed(sessionId);
                    if (websocket != null){
                        websocket.onMessage(this, data.getText());
                    }
                    continue;
                }
                
                //TODO 其他的后续再处理
            }
            catch (SocketTimeoutException e) 
            {//超时继续监听
                continue;
            }
            catch (Throwable e)
            {
                exception(e);
            }
        }
    }
}
