/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.bio;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Zips;

/**
 * HTTP请求类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpBioRequest extends HttpRequestAbs
{
    /** 构造函数 */
    public HttpBioRequest (HttpBioHeader header)
    {
        super(header);
    }
    
    /***********************************************************************/
    //解析请求头、内容、会话和证书等
    /***********************************************************************/
    
    /**
     * 分析请求内容
     * 
     * @exception IOException IO异常
     */
    public boolean parseContent() throws IOException
    {
        //第十二步，解析内容流
        int cLen = getContentLength();
        if (cLen <= 0)
        {//无内容
            bis = new ByteArrayInputStream(new byte[0]);
            return true;
        }
        
        //有内容
        byte[] contentBytes = Streams.getBytes(input, cLen);
        bis = new ByteArrayInputStream(contentBytes, 0, cLen);
        
        if (isRequestGZip())
            bis = Zips.unGZip(bis);
        
        if (_POST_.equals(header.getMethod()) && _APPLICATION_X_WWW_FORM_.equals(header.getMimeType()))
        {//form表单提交方式要解析到内容参数表中
            String line = new String(contentBytes, header.getCharacterEncoding());
            Urls.toMap(line, cntParamMap.instance(), header.getCharacterEncoding());
        }
        
        return true;
    }
}
