/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;

import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.kernel.util.Threads;

/**
 * HTTP连接信息类（连接即请求），包括输入输出流，实现Runnable，用于线程处理
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public final class HttpBioConnection implements HttpConnection, Runnable, HttpdConstants
{
    private String connId;
    
    private HttpListener listener;
    private Socket socket;
    private InetAddress remoteAddress;
    private InputStream input;
    private OutputStream output;
    
    //依次找到1.HttpHeader,2.HttpServer,3.HttpContext
    private HttpBioHeader header;
    
    //websocket
    private HttpBioWebsocketConnection websocket;
    
    public HttpBioConnection(HttpListener listener, Socket socket, InputStream input, OutputStream output)
    {//HTTP
        this.connId = sequence.nextString();
        
        this.listener = listener;
        this.socket = socket;
        this.remoteAddress = socket.getInetAddress();
        this.input = input;
        this.output = output;
        
        this.header = new HttpBioHeader(this);
    }
    
    public HttpBioConnection(HttpListener listener, Socket socket, InputStream input, OutputStream output, X509Certificate[] certs)
    {//HTTPS
        this(listener, socket, input, output);
        //用于业务再次认证
        this.header.setCertificates(certs);
    }
    
    /***********************************************************************/
    //获取连接对应的websocket属性
    /***********************************************************************/
    
    /** 是否是websocket连接 */
    public boolean isWebsocket()
    {
        return websocket != null;
    }
    
    /** 关联Websocket */
    public void doWebsocket(HttpContext context, String protocol, String sessionId)
    {
        this.websocket = new HttpBioWebsocketConnection(this, context, protocol, sessionId);
        this.websocket.open();
    }

    /** 是否活动 */
    public boolean isActive()
    {
        return true;
    }
    
    /** 是否超时 */
    public boolean isOvertime()
    {
        return false;
    }
    
    /** 是否已关闭 */
    public boolean isClosed()
    {
        return socket.isClosed();
    }
    
    /********************************************************************************/
    //处理请求
    /********************************************************************************/

    public void run()
    {
        try
        {
            header.execute();
        }
        catch (Exception e)
        {
            close();
        }
    }
    
    /** 写入数据 */
    public void write(byte[] data) throws IOException
    {
        write(data, 0, data.length);
    }
    
    /** 写入数据 */
    public void write(byte[] data, int off, int len) throws IOException
    {
        output.write(data, off, len);
    }
    
    /** 关闭连接 */
    public void close()
    {//由sender回调
        listener.remove(this);
        
        Threads.closeIgnoreException(input);
        Threads.closeIgnoreException(output);
        Threads.closeIgnoreException(socket);
    }
    
    
    /***********************************************************************/
    //获取连接属性上的参数
    /***********************************************************************/
    
    @Override
    public String getId()
    {
        return connId;
    }
    
    @Override
    public HttpListener getListener()
    {
        return listener;
    }
    
    @Override
    public String getRemoteAddr()
    {
        return remoteAddress.getHostAddress();
    }
    
    /***************************************************************************/
    //请求属性
    /***************************************************************************/
    
    public InputStream getInputStream()
    {
        return input;
    }
}
