/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.nio.ByteBuffer;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.HttpConstants;

/**
 * HTTPD常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("HttpdConstants")
public interface HttpdConstants extends HttpConstants
{
    //浏览器相关参数
    public static final String _ZHTTPD_                             = "zhiqim_httpd_v1.5.0";
    public static final String _TOKEN_                              = "_token_";
    public static final String _MSIE_                               = "msie";
    public static final String _MSTRIDENT_                          = "trident";
    public static final String _FIREFOX_                            = "firefox";
    public static final String _WEBKIT_                             = "webkit";
    public static final String _CHROME_                             = "chrome";
    public static final String _SAFARI_                             = "safari";
    public static final String _MOBILE_                             = "mobile";
    public static final String _WWW_                                = "www";
    public static final String _MICROMESSAGER_                      = "micromessenger";

    //默认的HTTP环境和会话管理器
    public static final String _HTTP_CONTEXT_CLASS_                 = "org.zhiqim.httpd.context.ZmlContext";
    public static final String _HTTP_SESSION_MANAGER_DEFAULT_       = "org.zhiqim.httpd.sessioner.HashSessionManager";
    public static final String _HTTP_SESSION_USER_                  = "org.zhiqim.httpd.HttpSessionUser";
    public static final String _HTTP_SESSION_IP_                    = "org.zhiqim.httpd.HttpSession.sessionIp";
    public static final String _HTTP_SESSION_UA_                    = "org.zhiqim.httpd.HttpSession.userAgent";
    public static final String _HTTP_REQUEST_PARAM_MATCH_           = "org.zhiqim.httpd.HttpRequest.paramMatch";
    
    //常用的SSL协议|算法和类型
    public static final String SSL_PROTOCOL                         = "TLS";    //协议
    public static final String SSL_ALGORITHM                        = "SunX509";//算法
    public static final String SSL_KEYSTORE_TYPE                    = "JKS";    //类型
    
    //常用的三个文件放到包里
    public static final String _PATH_FAVICON_ICO_                   = "/org/zhiqim/httpd/resources/favicon.ico";
    public static final String _PATH_CROSSDOMAIN_XML_               = "/org/zhiqim/httpd/resources/crossdomain.xml";
    public static final String _PATH_MIME_PROPERTIES_               = "/org/zhiqim/httpd/resources/mime.properties";

    //默认提供的处理器
    public static final String _PATH_FAVICON_                       = "/favicon.ico";
    public static final String _PATH_CROSSDOMAIN_                   = "/crossdomain.xml";
    public static final String _PATH_SERVICE_WS_                    = "/service/ws";
    
    //上下文环境的常量
    public static final String _CONTEXT_                            = "context";
    public static final String _SESSION_                            = "session";
    public static final String _SESSION_ID_                         = "sessionId";
    public static final String _SESSION_USER_                       = "sessionUser";
    public static final String _SESSION_NAME_                       = "sessionName";
    public static final String _REQUEST_                            = "request";
    public static final String _RESPONSE_                           = "response";
    public static final String _LOG_                                = "log";
    public static final String _AIO_                                = "AIO";
    public static final String _BIO_                                = "BIO";
    public static final String _NIO_                                = "NIO";
    public static final ByteBuffer _HELLO_N_                        = ByteBuffer.wrap(_ZHTTPD_.getBytes());
    
    //上下文环境的常量（知启蒙特有的定义）
    public static final String _ZHIQIM_CLIENT_TYPE_                 = "zhiqimClientType";
    
    //重定向支持的三个常量定义
    public static final String _REDIRECT_HISTORY_                   = "-1";         //后退，调用window.history.back();
    public static final String _REDIRECT_CLOSE_WINDOW_              = "closeWindow";//关闭窗口，调用window.close();
    public static final String _REDIRECT_CLOSE_DIALOG_              = "closeDialog";//关闭对话框，调用parent.Z.Dialog.close();
    
    //表单参数中两个重要标志
    public static final String _PARAM_CALL_FRAME_                   = "zCallFrame";
    public static final String _PARAM_FORM_INDEX_                   = "zFormIndex";
    public static final String _PARAM_DIALOG_FRAME_                 = "zDialogFrame";
    
    //HTTP协议长度定义
    public static final int _MAX_LINE_LEN_                          = 8 * KiB;
    public static final int _MAX_HEADER_LINE_                       = 128;
    public static final int _MAX_CONTENT_LEN_                       = 8 * MiB;
    public static final int _MAX_CHUNKED_SIZE_                      = MiB;
    public static final int _MAX_EXPIRES_                           = 3600;
    
    //标记连接处理进度
    public static final int _01_CREATE_                             = 1; //连接被listner创建
    public static final int _02_PARSE_HEADER_                       = 2; //解析请求头
    public static final int _03_CHECK_HEADER_                       = 3; //检查请求头
    public static final int _04_QUERY_CONTEXT_                      = 4; //查找Context
    public static final int _05_QUERY_HANDLER_                      = 5; //查找Handler
    public static final int _06_PARSE_CONTENT_                      = 6; //解析请求内容
    public static final int _07_HANDLER_BEGIN_                      = 7; //请求被Handler处理开始
    public static final int _08_INTERCEPTOR_                        = 8; //请求被Interceptor处理
    public static final int _09_ACTION_                             = 9; //请求被Action处理
    public static final int _10_HANDLER_END_                        = 10;//请求被Handler处理结束
    public static final int _11_COMMITTED_                          = 11;//提交响应完成
    public static final int _12_FINISHED_                           = 12;//结束请求处理
    
    public static final String _01_STEP_DESC_                       = "[创建]";
    public static final String _02_STEP_DESC_                       = "[解析请求头]";
    public static final String _03_STEP_DESC_                       = "[检查请求头]";
    public static final String _04_STEP_DESC_                       = "[查找上下文环境]";
    public static final String _05_STEP_DESC_                       = "[查找处理器]";
    public static final String _06_STEP_DESC_                       = "[解析请求内容]";
    public static final String _07_STEP_DESC_                       = "[处理开始]";
    public static final String _08_STEP_DESC_                       = "[拦截器处理中]";
    public static final String _09_STEP_DESC_                       = "[业务处理中]";
    public static final String _10_STEP_DESC_                       = "[处理完成]";
    public static final String _11_STEP_DESC_                       = "[正在提交]";
    public static final String _12_STEP_DESC_                       = "[提交完成]";
    
    //HTTP服务配置
    public static final String _SERVER_CONTEXT_                     = "context";
    
    //HTTP监听配置
    public static final String _LISTEN_SCHEME_                      = "scheme";
    public static final String _LISTEN_PORT_                        = "port";
    public static final String _LISTEN_IO_                          = "io";
    public static final String _LISTEN_IP_ADDRESS_                  = "ipAddress";
    public static final String _LISTEN_SO_ITMEOUT_                  = "soTimeout";
    public static final String _LISTEN_SO_LINGER_                   = "soLinger";
    public static final String _LISTEN_SO_RECV_BUF_                 = "soRecvBuf";
    public static final String _LISTEN_SO_SEND_BUF_                 = "soSendBuf";
    public static final String _LISTEN_SO_IDLE_TIME_                = "soIdleTime";
    public static final String _LISTEN_PO_MIN_SIZE_                 = "poMinSize";
    public static final String _LISTEN_PO_MAX_SIZE_                 = "poMaxSize";
    public static final String _LISTEN_PO_IDLE_TIME_                = "poIdleTime";
    public static final String _LISTEN_PO_QUEUE_SIZE_               = "poQueueSize";
    public static final String _LISTEN_ACCESS_LOG_                  = "accessLog";
    
    //HTTPS证书相关
    public static final String _KEY_STORE_PATH_                     = "keystorePath";
    public static final String _KEY_STORE_PASS_                     = "keystorePass";
    public static final String _TRUST_STORE_PATH_                   = "truststorePath";
    public static final String _TRUST_STORE_PASS_                   = "truststorePass";
    public static final String _CLIENT_AUTH_                        = "clientAuth";
    
    //HTTP Context配置
    public static final String _CONTEXT_DOMAIN_                     = "domain";
    public static final String _CONTEXT_PATH_                       = "path";
    public static final String _CONTEXT_CLASS_                      = "class";
    public static final String _CONTEXT_RESOURCE_TYPE_              = "resourceType";
    public static final String _CONTEXT_RESOURCE_PATH_              = "resourcePath";
    public static final String _CONTEXT_WELCOME_URL_                = "welcomeUrl";
    public static final String _CONTEXT_NOT_FOUND_URL_              = "notFoundUrl";
    public static final String _CONTEXT_MAX_CONTENT_LEN_            = "maxContentLength";
    public static final String _CONTEXT_CHUNK_SIZE_                 = "chunkSize";
    public static final String _CONTEXT_EXPIRES_                    = "expires";
    public static final String _CONTEXT_FILTER_                     = "filter";
    public static final String _CONTEXT_ENCODING_                   = "encoding";
    public static final String _CONTEXT_ORM_                        = "orm";
    
}
