/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.util.List;

/**
 * Websocket管理器定义
 *
 * @version v1.0.0 @author zouzhigang 2018-9-29 新建与整理
 */
public interface HttpWebsocketManager
{
    /** 获取管理器对应的上下文环境 */
    public HttpContext getContext();
    
    /********************************************************************/
    //开启和关闭
    /********************************************************************/
    
    /** 开启管理 */
    public void open();
    
    /** 关闭管理 */
    public void close();
    
    /*********************************************************************/
    //增加&删除&获取
    /*********************************************************************/
    
    /** 获取HttpWebsocket实现类 */
    public HttpWebsocket getWebsocket(String protocol);
    
    /** 获取协议名下所有连接 */
    public List<HttpWebsocketConnection> get(String protocol);
    
    /** 获取协议名下某个用户的所有连接 */
    public List<HttpWebsocketConnection> get(String protocol, String sessionId);
    
    /** 由HttpWebsocketService增加连接关联到会话 */
    public void add(HttpWebsocketConnection conn);
    
    /** 从连接中收到结束取消关联会话 */
    public void remove(HttpWebsocketConnection conn);
}
