/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;


/**
 * Websocket连接
 *
 * @version v1.0.0 @author zouzhigang 2018-5-29 新建与整理
 */
public interface HttpWebsocketConnection extends HttpdConstants
{
    public Log log = LogFactory.getLog(HttpWebsocketConnection.class);
    
    /***********************************************************************************/
    //打开&关闭
    /***********************************************************************************/
    
    /** 启动 */
    public void open();
    
    /** 关闭连接通知并删除 */
    public void close();
    
    /** 异常连接通知并删除 */
    public void exception(Throwable e);
    
    /***********************************************************************************/
    //发送数据
    /***********************************************************************************/
    
    /** 发送PING消息 */
    public boolean sendPing();
    
    /** 发送文本消息 */
    public boolean send(String text);
    
    /** 发送字节数据 */
    public boolean send(byte[] data);
    
    /***********************************************************************************/
    //获取属性
    /***********************************************************************************/
    
    /** 获取协议 */
    public String getProtocol();
    
    /** 获取会话管理器 */
    public HttpSessionManager getSessionManager();
    
    /** 获取会话，再通过管理器获取会话对象 */
    public String getSessionId();
    
    /** 获取会话信息 */
    public HttpSession getSession();
    
    /** 获取Websocket管理器 */
    public HttpWebsocketManager getWebsocketManager();
    
    /** 获取WebSocket对象 */
    public HttpWebsocket getWebsocket();
}
