/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import org.zhiqim.kernel.extend.HashMapSO;

/**
 * HTTP会话接口定义
 *
 * @version v1.0.0 @author zouzhigang 2016-7-15 新建与整理
 */
public interface HttpSession
{
    /************************************************************************************/
    //会话参数初始设置（IP地址 & 用户代理） 
    /************************************************************************************/
    
    public void setSessionIp(String sessionIp);
    
    public void setUserAgent(String userAgent);
    
    /************************************************************************************/
    //会话更新 & 失效
    /************************************************************************************/
    
    public void updateLastAccessed();
    
    public void updateInfo(String sessionIp, String userAgent);
    
    public void invalidate();
    
    /************************************************************************************/
    //用于业务浸入式更改sessionId（注：谨慎使用），HttpResponse会oldSessionId进行处理
    /************************************************************************************/
    
    public void setNewSessionId(String newSessionId);
    
    public String getOldSessionId();
    
    public void clearOldSessionId();
    
    /************************************************************************************/
    //获取参数判断值
    /************************************************************************************/
    
    public HttpContext getContext();
    
    public String getId();
    
    public boolean isNew();
    
    public String getSessionIp();
    
    public String getUserAgent();
    
    public int getMaxInactiveInterval();
    
    public long getCreated();
    
    public String getCreateTime();
    
    public long getLastAccessed();
    
    public String getLastAccessTime();
    
    public long getRemainSecond();
    
    public long getRemainMinute();
    
    public long[] getRemainTime();
    
    public String getRemainTimeDesc();
    
    /**********************************************/
    //读写关联到HttpSession中attribute列表
    /**********************************************/
    
    public HashMapSO getAttributes();
    
    public Object getAttribute(String name);
    
    public Object removeAttribute(String name);
    
    public void setAttribute(String name, Object value);
    
    public boolean hasAttribute(String name);
    
    public Object getAttribute(String name, Object defaultValue);
    
    public String getAttributeString(String name);
    
    public String getAttributeString(String name, String defaultValue);
    
    public int getAttributeInt(String name);
    
    public int getAttributeInt(String name, int defaultValue);
    
    public long getAttributeLong(String name);
    
    public long getAttributeLong(String name, long defaultValue);
    
    public boolean getAttributeBoolean(String name, boolean defaultValue);
    
    /**********************************************/
    //SessionUser相关
    /**********************************************/    
    
    /** 判断会话中是否有用户信息 */
    public boolean hasSessionUser();
    
    /** 获取会话用户信息中用户类，多个时抛异常 */
    public HttpSessionUser getSessionUser();
    
    /** 获取会话用户名称，多个时抛异常 */
    public String getSessionName();
    
    /** 绑定会话用户信息 */
    public void bindSessionUser(HttpSessionUser sessionUser);
    
    /** 解绑会话用户信息 */
    public void unbindSessionUser();
    
    /** 判断会话中是否有用户信息且指定的用户类 */
    public <T extends HttpSessionUser> boolean hasSessionUser(Class<T> clazz);
    
    /** 获取会话用户信息且指定的用户类 */
    public <T extends HttpSessionUser> T getSessionUser(Class<T> clazz);
}
