/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;

/**
 * 对应HTTP一个处理的实体，和HttpHandler不同的是：
 * 1.只需消息头内容
 * 2.对应实际的一个文件或处理，无其他业务逻辑
 * 3.处理完成后即发送
 * 
 * 用于静态文件等，无需创建复杂的HttpRequest和HttpResponse
 *
 * @see HttpExecutor  业务处理器
 * @version v1.0.0 @author zouzhigang 2016-7-19 新建与整理
 */
public interface HttpEntity extends HttpHandler
{
    /**
     * 处理HTTP请求, 来自GET,POST方法
     * 
     * @param header        请求头
     * @param sender        响应发送者
     * @throws IOException  异常
     */
    public void handle(HttpHeader header, HttpSender sender) throws IOException;
}
