/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.seqs.Sequence;

/**
 * HTTP连接接口定义
 *
 * @version v1.0.0 @author zouzhigang 2016-7-18 新建与整理
 */
public interface HttpConnection extends HttpdConstants
{
    public Log log = LogFactory.getLog(HttpConnection.class);
    public Sequence sequence = new Sequence(6);
    
    /********************************************************************/
    //连接中状态
    /********************************************************************/
    
    /** 是否活动 */
    public boolean isActive();
    
    /** 是否超时 */
    public boolean isOvertime();
    
    /** 是否已关闭 */
    public boolean isClosed();
    
    /********************************************************************/
    //连接中的websocket
    /********************************************************************/
    
    /** 是否是websocket连接 */
    public boolean isWebsocket();
    
    /** 升级为Websocket连接 */
    public void doWebsocket(HttpContext context, String protocol, String sessionId);
    
    /********************************************************************/
    //连接中write&close
    /********************************************************************/
    
    /** 写入数据 */
    public void write(byte[] data) throws IOException;
    
    /** 写入数据 */
    public void write(byte[] data, int off, int len) throws IOException;
    
    /** 关闭连接 */
    public void close();
    
    /********************************************************************/
    //连接中的相关连的 id & listener
    /********************************************************************/
    
    /** 连接编号 */
    public String getId();
    
    /** 连接对应的监听器 */
    public HttpListener getListener();
    
    /** 获取远程地址 */
    public String getRemoteAddr();
}
