/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;

@AnAlias(value={"Zips"})
public class Zips
implements CodeConstants {
    public static void zip(String fileDirPath, String zipExportPath) throws Exception {
        Asserts.notEmpty(fileDirPath, "\u6587\u4ef6\u76ee\u5f55\u8def\u5f84");
        Asserts.notEmpty(zipExportPath, "ZIP\u5bfc\u51fa\u8def\u5f84");
        File fileDir = new File(fileDirPath);
        Asserts.as(fileDir.exists() ? null : "\u6587\u4ef6\u76ee\u5f55\u8def\u5f84\u4e0d\u5b58\u5728");
        String fileDirCanonicalPath = Files.toLinuxPath(fileDir.getCanonicalPath());
        FileOutputStream fos = new FileOutputStream(zipExportPath);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)fos, _UTF_8_C_);
        zos.setLevel(9);
        ArrayList<File> fileList = new ArrayList<File>();
        Files.queryFileList(fileList, fileDir, 0);
        for (File file : fileList) {
            String name = Files.toLinuxPath(file.getCanonicalPath());
            name = file.isDirectory() ? String.valueOf(name.substring(fileDirCanonicalPath.length() + 1)) + "/" : name.substring(fileDirCanonicalPath.length() + 1);
            ZipEntry ze = new ZipEntry(name);
            ze.setSize(file.length());
            ze.setTime(file.lastModified());
            zos.putNextEntry(ze);
            if (ze.isDirectory()) {
                zos.closeEntry();
                continue;
            }
            Throwable throwable = null;
            Object var12_13 = null;
            try (FileInputStream is = new FileInputStream(file);){
                Streams.putBytes(is, zos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            zos.closeEntry();
        }
        zos.close();
    }

    public static List<File> unzip(File zip, File toDir) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                Files.mkDirectory(new File(toDir, entry.getName()));
                continue;
            }
            InputStream input = null;
            OutputStream output = null;
            try {
                File file = new File(toDir, entry.getName());
                input = zipFile.getInputStream(entry);
                output = new FileOutputStream(file);
                Streams.putBytes(input, output);
                fileList.add(file);
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (output == null) continue;
                output.close();
            }
            catch (Exception exception) {}
        }
        zipFile.close();
        return fileList;
    }

    public static ByteArrayOutputStream gzip(ByteArrayOutputStream output) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPOutputStream gzip = new GZIPOutputStream(bos);){
            output.writeTo(gzip);
            gzip.finish();
            return bos;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] gzipString(String src, String encoding) throws IOException {
        if (src == null) {
            return new byte[0];
        }
        try {
            return Zips.gzip(src.getBytes(encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    public static byte[] gzip(byte[] src) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPOutputStream gzip = new GZIPOutputStream(output);){
            gzip.write(src);
            gzip.finish();
            return output.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] unGZip(byte[] src) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(src);
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPInputStream gzip = new GZIPInputStream(input);){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Streams.putBytes(gzip, output);
            return output.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ByteArrayInputStream unGZip(InputStream input) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (GZIPInputStream gzip = new GZIPInputStream(input);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.putBytes(gzip, out);
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String unGZipString(byte[] src, String encoding) {
        try {
            byte[] dest = Zips.unGZip(src);
            return new String(dest, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u7f16\u7801\u53c2\u6570[%s]", encoding);
        }
        catch (IOException e) {
            throw Asserts.exception(e);
        }
    }

    public static File unGZip(File gzip, File toDir) throws IOException {
        Files.mkDirectory(toDir);
        File file = new File(toDir, gzip.getName());
        FileInputStream fis = null;
        FileOutputStream fos = null;
        GZIPInputStream input = null;
        try {
            fis = new FileInputStream(gzip);
            fos = new FileOutputStream(file);
            input = new GZIPInputStream(fis);
            Streams.putBytes(input, fos);
        }
        catch (Throwable throwable) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Exception exception) {}
        return file;
    }
}

