/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Replaces;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Systems"})
public class Systems {
    public static boolean isWindows() {
        return Strings.startsWithIgnoreCase(Systems.getOsName(), "windows");
    }

    public static boolean isMacOS() {
        String osName = Systems.getOsName();
        return Strings.startsWithIgnoreCase(osName, "mac") || Strings.startsWithIgnoreCase(osName, "darwin");
    }

    public static boolean isLinux() {
        return Strings.startsWithIgnoreCase(Systems.getOsName(), "linux");
    }

    public static int getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        return Ints.toInt(name.substring(0, name.indexOf(64)), -1);
    }

    public static boolean isJavaVersionMoreThen5() {
        return Systems.getJavaVersion().compareTo("1.5") >= 0;
    }

    public static boolean isJavaVersionMoreThen6() {
        return Systems.getJavaVersion().compareTo("1.6") >= 0;
    }

    public static boolean isJavaVersionMoreThen7() {
        return Systems.getJavaVersion().compareTo("1.7") >= 0;
    }

    public static boolean isJavaVersionMoreThen8() {
        return Systems.getJavaVersion().compareTo("1.8") >= 0;
    }

    public static String getClassPathSeparator() {
        return Systems.getPathSeparator();
    }

    public static void addLibraryPath(String dir) {
        String libraryPath = System.getProperty("java.library.path");
        System.setProperty("java.library.path", String.valueOf(dir) + Systems.getClassPathSeparator() + libraryPath);
    }

    public static String[] getClassPaths() {
        return Arrays.toStringArray(Systems.getClassPath(), Systems.getClassPathSeparator());
    }

    public static List<String> getClassPathList() {
        return Lists.toStringList(Systems.getClassPath(), Systems.getClassPathSeparator());
    }

    public static void setClassPath(String classPath) {
        System.setProperty("java.class.path", classPath);
    }

    public static void setProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static String getEnv(String key) {
        return System.getenv(key);
    }

    public static String getPropOrEnv(String key) {
        String value = System.getProperty(key);
        return value == null ? System.getenv(key) : value;
    }

    public static String replaceProperty(String str) {
        int eInd;
        int sInd;
        if (Validates.isEmpty(str)) {
            return str;
        }
        while ((sInd = str.indexOf("${")) != -1 && (eInd = str.indexOf("}", sInd + 2)) != -1 && eInd > sInd + 2) {
            String env = str.substring(sInd + 2, eInd);
            String value = Systems.getProperty(env);
            str = Replaces.replaceAllEscape(str, "${" + env + "}", value);
        }
        return str;
    }

    public static String replacePropertyPath(String str) {
        return Validates.isEmpty(str) ? str : Replaces.replaceAllEscape(Systems.replaceProperty(str), "\\", "/");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsArch() {
        return System.getProperty("os.arch");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public static String getVmInfo() {
        return System.getProperty("java.vm.info");
    }

    public static String getVmName() {
        return System.getProperty("java.vm.name");
    }

    public static String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getSystemEncoding() {
        return System.getProperty("sun.jnu.encoding");
    }

    public static String getHosthame() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            return localMachine.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }
}

