/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Validates;

public class ScheduleFactory
implements SignConstants {
    public static Object getTaskThreader(String taskClassName, String taskValue) {
        if (Validates.isEmpty(taskClassName) || Validates.isEmpty(taskValue)) {
            return null;
        }
        Object task = Global.newInstance(taskClassName);
        if (task == null || !(task instanceof Task)) {
            return null;
        }
        HashMapSS paramMap = Jsons.toMapSS(taskValue);
        String name = paramMap.get("name");
        if (Validates.isEmptyBlank(name)) {
            return null;
        }
        if ("Interval".equals(name)) {
            return ScheduleFactory.getTaskInterval((Task)task, paramMap);
        }
        return ScheduleFactory.getTaskThreader((Task)task, paramMap);
    }

    public static TaskThreader getTaskThreader(Task task, String param) {
        HashMapSS paramMap = Jsons.toMapSS(param);
        if (!paramMap.containsKey("name") || !paramMap.containsKey("time")) {
            return null;
        }
        return ScheduleFactory.getTaskThreader(task, paramMap);
    }

    public static TaskThreader getTaskThreader(Task task, MapSS paramMap) {
        String name = paramMap.get("name");
        String time = paramMap.get("time");
        String first = paramMap.get("first");
        int[] timeArr = Arrays.toIntArray(time, "/");
        boolean isFirst = first == null ? false : "true".equals(first);
        Object obj = Global.newInstance(name);
        if (obj == null || !(obj instanceof TaskThreader)) {
            return null;
        }
        TaskThreader threader = (TaskThreader)obj;
        if (isFirst) {
            threader.setFirstPreviousExecute();
        }
        return threader.schedule(task, timeArr);
    }

    public static Interval getTaskInterval(Task task, MapSS paramMap) {
        String time = paramMap.get("time");
        String first = paramMap.get("first");
        if (!Validates.isIntegerValue(time, 1, Integer.MAX_VALUE)) {
            return null;
        }
        boolean isFirst = first == null ? false : "true".equals(first);
        int middleMillis = Ints.toInt(time) * 1000;
        int firstMillis = isFirst ? 0 : middleMillis;
        return Interval.shedule(task, firstMillis, middleMillis);
    }
}

