/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class HttpPut
extends HttpClient {
    private byte[] bytes;
    private String mimeType;
    private String encoding;

    public HttpPut(String url) {
        super(url, "PUT");
    }

    public void setContentType(String mimeType, String encoding) {
        this.mimeType = Strings.trim(mimeType);
        this.encoding = Strings.trim(encoding);
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    protected boolean doPreRequestProperty() {
        if (this.bytes == null || this.bytes.length == 0) {
            return true;
        }
        this.setDoOutput(true);
        if (!this.hasRequestProperty("Content-Type") && Validates.isNotEmpty(this.mimeType)) {
            if (Validates.isEmpty(this.encoding)) {
                this.addRequestProperty("Content-Type", this.mimeType);
            } else {
                this.addRequestProperty("Content-Type", String.valueOf(this.mimeType) + "; charset=" + this.encoding);
            }
        }
        this.addRequestProperty("Content-Length", "" + this.bytes.length);
        return true;
    }

    @Override
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
        if (this.bytes == null || this.bytes.length == 0) {
            return;
        }
        conn.getOutputStream().write(this.bytes);
    }
}

