/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.control;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.control.Handlee;
import org.zhiqim.kernel.control.Handler;
import org.zhiqim.kernel.control.ThreaderController;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.MapCV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Randoms;

public class HandlerController
extends ThreaderController {
    private static final Log log = LogFactory.getLog(HandlerController.class);
    private static final String DEFAULT = "default";
    private Handler<?> defaultHandler = null;
    private final MapCV<Handler<?>> handlerMap = new HashMapCV();

    public HandlerController() {
        this.setThreadName("Handler-" + Randoms.upperLetters(1) + Randoms.lowerLettersDigits(3));
    }

    @Override
    public boolean openBefore() {
        super.openBefore();
        if (this.id == null) {
            return true;
        }
        Group group = Global.getGroup(String.valueOf(this.id) + ".handler");
        if (group == null || group.isEmpty()) {
            return true;
        }
        for (Item item : group.list()) {
            String className = item.getKey();
            String handlerName = item.getString();
            Object handler = Global.newInstance(handlerName);
            if (handler == null || !(handler instanceof Handler)) {
                log.error((Object)"\u914d\u7f6e[%s]\u4e2d\uff0c[%s]\u7c7b\u4e0d\u5b58\u5728\u6216\u672a\u5b9e\u73b0Handler\u63a5\u53e3", group.getId(), handlerName);
                return false;
            }
            if (DEFAULT.equals(className)) {
                this.setDefaultHandler((Handler)handler);
                continue;
            }
            Class<?> cls = Global.forName(className);
            if (cls == null) {
                log.error((Object)"\u914d\u7f6e[%s]\u4e2d\uff0c[%s]\u7c7b\u4e0d\u5b58\u5728", group.getId(), className);
                return false;
            }
            this.handlerMap.put(cls, (Handler)handler);
        }
        return true;
    }

    @Override
    public void closeAfter() {
        super.closeAfter();
        this.defaultHandler = null;
        this.handlerMap.clear();
    }

    public <T> void setDefaultHandler(Handler<T> handler) {
        this.defaultHandler = handler;
    }

    public void clearDefaultHandler() {
        this.defaultHandler = null;
    }

    public <T> void addHandler(Class<T> requestClass, Handler<T> handler) {
        this.handlerMap.put(requestClass, handler);
    }

    public <T> void removeHandler(Class<T> requestClass) {
        this.handlerMap.remove(requestClass);
    }

    public boolean execute(Object event) {
        return this.execute(event, false);
    }

    public boolean execute(Object event, boolean priority) {
        Handler<?> handler = this.handlerMap.get(event.getClass());
        if (handler == null) {
            handler = this.defaultHandler;
        }
        if (handler == null) {
            log.fatal((Object)"\u4e8b\u4ef6\u5904\u7406\u5668[%s]\u672a\u914d\u7f6e\u5904\u7406\u5668", event.getClass().getName());
            return false;
        }
        Handlee<Object> command = new Handlee<Object>(event, handler);
        return super.execute(command, priority);
    }
}

