/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.rule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.rule.CheckRule;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.project.ZpmConstants;
import org.zhiqim.project.ZpmProjectDao;
import org.zhiqim.project.dbo.ZpmMember;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.mutables.MObj;

/**
 * 页面验证是否有管理权限，返回boolean =true表示有，=false表示没有
 *
 * @version v1.0.0 @author zouzhigang 2017-10-16 新建与整理
 */
@AnAlias("ZpmManageRule")
@AnGlobal
public class ZpmManageRule implements CheckRule, ZpmConstants
{
    public boolean check(HttpRequest request) throws Exception
    {
        int result = prefix(request, new MObj<ZpmMember>());
        
        switch (result)
        {
        case FPM_RULE_SUCC:  return true;
        case FPM_RULE_FAIL: return false;
        default: return false;
        }
    }
    
    public static int prefix(HttpRequest request, MObj<ZpmMember> member) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        if (sessionUser == null)
        {// 用户未登录或超时
            return FPM_RULE_FAIL;
        }
        
        if (sessionUser.isAdmin())
        {//管理员或超级管理员有所有项目权限
            return FPM_RULE_SUCC;
        }
        
        long projectId = sessionUser.getOperatorParamLong(FPM_PROJECT_ID_KEY);
        if (projectId == -1)
        {//未选中项目
            return FPM_RULE_FAIL;
        }
        
        ZpmMember mem = (ZpmMember)sessionUser.getValue(FPM_MEMBER_KEY);
        if (mem == null || mem.getProjectId() != projectId)
        {//有选中项目，但未加载项目对象到会话中时，主动加载一次
            ZpmProjectDao.setProjectMember(request, sessionUser, projectId);
            mem = (ZpmMember)sessionUser.getValue(FPM_MEMBER_KEY);
        }
        
        if (mem == null)
        {//重新获取也没有成员会话信息
            return FPM_RULE_FAIL;
        }
        
        if (mem.getMemberType() == 0 || Strings.contains(mem.getMemberRole(), FPM_ROLE_MANAGE))
        {//组长有所有权限
            return FPM_RULE_SUCC;
        }
        
        member.val(mem);
        return FPM_RULE_INIT;
    }
}
