/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.rule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.rule.CheckRule;
import org.zhiqim.project.ZpmConstants;
import org.zhiqim.project.dbo.ZpmMember;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.mutables.MObj;

/**
 * 页面验证是否有开发或设计权限，返回boolean =true表示有，=false表示没有
 *
 * @version v1.0.0 @author zouzhigang 2017-10-16 新建与整理
 */
@AnAlias("ZpmDevDesignRule")
@AnGlobal
public class ZpmDevDesignRule implements CheckRule, ZpmConstants
{
    public boolean check(HttpRequest request) throws Exception
    {
        MObj<ZpmMember> member = new MObj<>();
        int result = ZpmManageRule.prefix(request, member);
        
        switch (result)
        {
        case FPM_RULE_SUCC:  return true;
        case FPM_RULE_FAIL: return false;
        default: 
        {
            String role = member.value.getMemberRole();
            return Strings.contains(role, FPM_ROLE_DEVELOPMENT) ||
                    Strings.contains(role, FPM_ROLE_DESIGN);
        }
        }
    }
}
