/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.dbo;

import java.io.Serializable;
import java.sql.Timestamp;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 项目动态表 对应表《ZPM_REPORT》
 */
@AnAlias("ZpmReport")
@AnTable(table="ZPM_REPORT", key="REPORT_ID", type="InnoDB")
public class ZpmReport implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="PROJECT_ID", type="long", notNull=true)    private long projectId;    //1.项目编号
    @AnTableField(column="OPERATOR_CODE", type="string,32", notNull=true)    private String operatorCode;    //2.操作员编码
    @AnTableField(column="REPORT_ID", type="long", notNull=true)    private long reportId;    //3.动态编号
    @AnTableField(column="REPORT_TIME", type="datetime", notNull=true)    private Timestamp reportTime;    //4.动态时间
    @AnTableField(column="REPORT_DESC", type="string,200", notNull=false)    private String reportDesc;    //5.动态描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getProjectId()
    {
        return projectId;
    }

    public void setProjectId(long projectId)
    {
        this.projectId = projectId;
    }

    public String getOperatorCode()
    {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode)
    {
        this.operatorCode = operatorCode;
    }

    public long getReportId()
    {
        return reportId;
    }

    public void setReportId(long reportId)
    {
        this.reportId = reportId;
    }

    public Timestamp getReportTime()
    {
        return reportTime;
    }

    public void setReportTime(Timestamp reportTime)
    {
        this.reportTime = reportTime;
    }

    public String getReportDesc()
    {
        return reportDesc;
    }

    public void setReportDesc(String reportDesc)
    {
        this.reportDesc = reportDesc;
    }

}
