/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.dbo;

import org.zhiqim.project.dbo.ZpmMember;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 项目成员视图 对应视图《ZPM_MEMBER_EX》
 */
@AnAlias("ZpmMemberEx")
@AnView("ZPM_MEMBER,ZMR_OPERATOR")
@AnViewJoin({@AnViewJoinValue(type="EQUAL", lTable="ZPM_MEMBER", lColumn="OPERATOR_CODE", rTable="ZMR_OPERATOR", rColumn="OPERATOR_CODE")})
public class ZpmMemberEx extends ZpmMember
{
    private static final long serialVersionUID = 1L;

    @AnViewField(table="ZMR_OPERATOR", column="OPERATOR_NAME")    private String operatorName;    //2.操作员名称
    @AnViewField(table="ZMR_OPERATOR", column="OPERATOR_AVATAR")    private long operatorAvatar;    //3.操作员头像编号
    @AnViewField(table="ZMR_OPERATOR", column="OPERATOR_TYPE")    private int operatorType;    //4.操作员类型：0：超级管理员,1：管理员，2:操作员

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getOperatorName()
    {
        return operatorName;
    }

    public void setOperatorName(String operatorName)
    {
        this.operatorName = operatorName;
    }

    public long getOperatorAvatar()
    {
        return operatorAvatar;
    }

    public void setOperatorAvatar(long operatorAvatar)
    {
        this.operatorAvatar = operatorAvatar;
    }

    public int getOperatorType()
    {
        return operatorType;
    }

    public void setOperatorType(int operatorType)
    {
        this.operatorType = operatorType;
    }

}
