/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 项目成员表 对应表《ZPM_MEMBER》
 */
@AnAlias("ZpmMember")
@AnTable(table="ZPM_MEMBER", key="PROJECT_ID,OPERATOR_CODE", type="InnoDB")
public class ZpmMember implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="PROJECT_ID", type="long", notNull=true)    private long projectId;    //1.项目编号
    @AnTableField(column="OPERATOR_CODE", type="string,32", notNull=true)    private String operatorCode;    //2.操作员编码
    @AnTableField(column="MEMBER_TYPE", type="byte", notNull=true)    private int memberType;    //3.成员类型，0：负责人，1：普通成员
    @AnTableField(column="MEMBER_ROLE", type="string,64", notNull=false)    private String memberRole;    //4.成员角色，多个用逗号隔开，如demand,development表示需求和开发角色

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getProjectId()
    {
        return projectId;
    }

    public void setProjectId(long projectId)
    {
        this.projectId = projectId;
    }

    public String getOperatorCode()
    {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode)
    {
        this.operatorCode = operatorCode;
    }

    public int getMemberType()
    {
        return memberType;
    }

    public void setMemberType(int memberType)
    {
        this.memberType = memberType;
    }

    public String getMemberRole()
    {
        return memberRole;
    }

    public void setMemberRole(String memberRole)
    {
        this.memberRole = memberRole;
    }

}
