/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.project.ZpmConstants;
import org.zhiqim.project.dbo.ZpmPersonReader;

/**
 *  查看个人计划总结月表 
 *
 * @version v1.0.0 @author zouzhigang 2017-11-2 新建与整理
 */
public class ReportReviewAction implements Action, ZpmConstants
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        String operatorCode = request.getParameter("operatorCode");
        if (Validates.isEmptyBlank(operatorCode))
        {
            request.returnHistory("请选择一个成员");
            return;
        }
        
        ZmrOperator operator = ORM.get(ZTable.class, request).item(ZmrOperator.class, operatorCode);
        if (operator == null)
        {
            request.returnHistory("请选择一个有效成员");
            return;
        }
        
        ZpmPersonReader reader = ORM.get(ZTable.class, request).item(ZpmPersonReader.class, operatorCode, request.getSessionName());
        if (reader == null)
        {
            request.returnHistory("请选择一个有权限的成员");
            return;
        }
        
        request.setAttribute("operator", operator);
        
        //生成个人项目动态
        PersonReportAction.report(request, operatorCode);
    }
}
