/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.action;

import java.util.Iterator;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.project.ZpmConstants;
import org.zhiqim.project.ZpmProjectDao;
import org.zhiqim.project.dbo.ZpmMember;

/**
 * 增加项目成员
 *
 * @version v1.0.0 @author huangsufang 2017-9-25 新建与整理
 */
public class MemberSelectorAction implements Action, ZpmConstants
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        long projectId = ZpmProjectDao.getProjectId(request);
        List<ZpmMember> memberList = ORM.get(ZTable.class, request).list(ZpmMember.class, new Selector("operatorCode", "projectId", projectId));
        
        Selector selector = new Selector();
        selector.addMust("operatorStatus", 0);
        String operatorKey = request.getParameter("operatorKey");
        if (Validates.isNotEmpty(operatorKey))
        {//条件
            selector.addOr(new Selector().addMaybeLike("operatorCode", operatorKey).addMaybeLike("operatorName", operatorKey));
        }
        
        List<ZmrOperator> operatorList = ORM.get(ZTable.class, request).list(ZmrOperator.class, selector);
        
        for (Iterator<ZmrOperator> it = operatorList.iterator();it.hasNext();)
        {
            ZmrOperator operator = it.next();
            if (isContain(memberList, operator))
            {//如果在成员表中则删除
                it.remove();
            }
        }
      
        request.setAttribute("operatorList", operatorList);
    }
    
    private boolean isContain(List<ZpmMember> memberList, ZmrOperator operator)
    {
        for (ZpmMember member : memberList)
        {
            if (operator.getOperatorCode().equals(member.getOperatorCode()))
                return true;
        }
        
        return false;
    }
}

