/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.impl;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.zhiqim.kernel.MultiInstancer;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMI18n;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ZSQL;
import org.zhiqim.orm.ZTabler;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.orm.dbo.UpdaterField;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.dbo.defined._TableField;

public final class ZTablerImplement
extends MultiInstancer
implements ZTabler,
ORMConstants {
    private static final Log log = LogFactory.getLog(ZTablerImplement.class);
    private ORMServer server;
    private ZSQL zSQL;
    private HashSet<String> existTableList;
    private Object createTableLock;

    public ZTablerImplement(ORMServer server) {
        this.server = server;
        this.zSQL = server.sql();
        this.existTableList = new HashSet();
        this.createTableLock = new Object();
    }

    public ORMServer getServer() {
        return this.server;
    }

    @Override
    public boolean exist(_Table _table) throws ORMException, SQLException {
        return this.exist(_table, (MapSS)new HashMapSS());
    }

    @Override
    public boolean exist(_Table _table, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[exist][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[exist][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.chkReplace(replaceMap);
        String table = Sqls.formatReplaceMap((String)_table.getTable(), (MapSS)replaceMap);
        if (this.existTableList.contains(table)) {
            return true;
        }
        boolean exist = this.zSQL.existTable(table);
        if (exist) {
            this.existTableList.add(table);
        }
        return exist;
    }

    @Override
    public void create(_Table table) throws ORMException, SQLException {
        this.create(table, (MapSS)new HashMapSS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(_Table _table, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[create][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[create][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.chkReplace(replaceMap);
        if (this.exist(_table, replaceMap)) {
            return;
        }
        Object object = this.createTableLock;
        synchronized (object) {
            if (this.exist(_table, replaceMap)) {
                return;
            }
            List<String> sqlList = this.server.getPolicy().toTableString(_table, replaceMap);
            this.zSQL.execute(sqlList);
        }
        String tableName = Sqls.formatReplaceMap((String)_table.getTable(), (MapSS)replaceMap);
        log.info((Object)"\u521b\u5efa\u8868[%s]\u6210\u529f", new Object[]{tableName});
    }

    @Override
    public void drop(_Table _table) throws ORMException, SQLException {
        this.drop(_table, null);
    }

    @Override
    public void drop(_Table _table, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[drop][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[drop][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        _table.chkReplace(replaceMap);
        String tableName = Sqls.formatReplaceMap((String)_table.getTable(), (MapSS)replaceMap);
        if (!this.zSQL.existTable(tableName)) {
            this.existTableList.remove(tableName);
            return;
        }
        this.zSQL.execute("drop table " + tableName + ";");
        this.existTableList.remove(tableName);
        log.info((Object)"\u5220\u9664\u8868[%s]\u6210\u529f", new Object[]{tableName});
    }

    @Override
    public void truncate(_Table _table) throws ORMException, SQLException {
        this.truncate(_table, (MapSS)new HashMapSS());
    }

    @Override
    public void truncate(_Table _table, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[truncate][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[truncate][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        String tableName = Sqls.formatReplaceMap((String)_table.getTable(), (MapSS)replaceMap);
        if (!this.server.isSqlite()) {
            this.create(_table, replaceMap);
            this.zSQL.execute("truncate table " + tableName);
        } else {
            if (this.zSQL.existTable(tableName)) {
                this.zSQL.execute("drop table " + tableName);
                this.existTableList.remove(tableName);
            }
            this.create(_table, replaceMap);
        }
    }

    @Override
    public int insert(_Table _table, LinkedMapSO data) throws ORMException, SQLException {
        return this.insert(_table, data, (MapSS)new HashMapSS());
    }

    @Override
    public int insertMonth(_Table _table, LinkedMapSO data, String month) throws ORMException, SQLException {
        return this.insert(_table, data, (MapSS)new HashMapSS("MONTH", month));
    }

    @Override
    public int insert(_Table _table, LinkedMapSO data, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[insert][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[insert][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, replaceMap);
        String sql = this.toInsertOrReplaceSQL(_table, "insert");
        this.replaceFieldToColumn(data, _table);
        return this.zSQL.executeUpdate(sql, data, replaceMap);
    }

    @Override
    public int insertOrUpdate(_Table _table, LinkedMapSO data, Updater updater) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[insertOrUpdate][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!this.server.isMysql()) {
            throw new ORMException("ZTabler[insertOrUpdate]\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b]");
        }
        this.create(_table, (MapSS)updater.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String insertSQL = this.toInsertOrUpdateSQL(_table, data, (MapSO)paramMap);
        String updateSQL = this.toUpdateFieldSQL(_table, updater, (MapSO)paramMap);
        StringBuilder sql = new StringBuilder(insertSQL).append(" on duplicate key update ").append(updateSQL);
        return this.zSQL.executeUpdate(sql.toString(), paramMap, (MapSS)updater.getReplaceMap());
    }

    @Override
    public int[] insertBatch(_Table _table, List<LinkedMapSO> dataList) throws ORMException, SQLException {
        return this.insertBatch(_table, dataList, (MapSS)new HashMapSS());
    }

    @Override
    public int[] insertBatch(_Table _table, List<LinkedMapSO> dataList, MapSS replaceMap) throws ORMException, SQLException {
        if (dataList == null || dataList.isEmpty()) {
            return new int[0];
        }
        if (_table == null) {
            throw new ORMException("ZTabler[insertBatch][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[insertBatch][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, replaceMap);
        String sql = this.toInsertOrReplaceSQL(_table, "insert");
        for (LinkedMapSO data : dataList) {
            this.replaceFieldToColumn(data, _table);
        }
        return this.zSQL.executeBatch(sql, dataList, replaceMap);
    }

    @Override
    public int replace(_Table _table, LinkedMapSO data) throws ORMException, SQLException {
        return this.replace(_table, data, (MapSS)new HashMapSS());
    }

    @Override
    public int replaceMonth(_Table _table, LinkedMapSO data, String month) throws ORMException, SQLException {
        HashMapSS replaceMap = new HashMapSS();
        replaceMap.put("MONTH", month);
        return this.replace(_table, data, (MapSS)replaceMap);
    }

    @Override
    public int replace(_Table _table, LinkedMapSO data, String replaceKey, String replaceValue) throws ORMException, SQLException {
        HashMapSS replaceMap = new HashMapSS();
        replaceMap.put(replaceKey, replaceValue);
        return this.replace(_table, data, (MapSS)replaceMap);
    }

    @Override
    public int replace(_Table _table, LinkedMapSO data, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[replace][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!this.server.isMysql() && !this.server.isSqlite()) {
            throw new ORMException("ZTabler[replace]\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[replace][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, replaceMap);
        String sql = this.toInsertOrReplaceSQL(_table, "replace");
        this.replaceFieldToColumn(data, _table);
        return this.zSQL.executeUpdate(sql, data, replaceMap);
    }

    @Override
    public int[] replaceBatch(_Table _table, List<LinkedMapSO> dataList) throws ORMException, SQLException {
        return this.replaceBatch(_table, dataList, (MapSS)new HashMapSS());
    }

    @Override
    public int[] replaceBatch(_Table _table, List<LinkedMapSO> dataList, MapSS replaceMap) throws ORMException, SQLException {
        if (dataList == null || dataList.isEmpty()) {
            return new int[0];
        }
        if (_table == null) {
            throw new ORMException("ZTabler[replaceBatch][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!this.server.isMysql() && !this.server.isSqlite()) {
            throw new ORMException("ZTabler[replaceBatch]\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b]");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[replaceBatch][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, replaceMap);
        String sql = this.toInsertOrReplaceSQL(_table, "replace");
        for (LinkedMapSO data : dataList) {
            this.replaceFieldToColumn(data, _table);
        }
        return this.zSQL.executeBatch(sql, dataList, replaceMap);
    }

    @Override
    public int update(_Table _table, Updater updater) throws ORMException, SQLException {
        if (updater == null) {
            throw new ORMException("ZTabler[update][updater\u4e0d\u5141\u8bb8\u4e3anull]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[update][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)updater.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String fieldSQL = this.toUpdateFieldSQL(_table, updater, (MapSO)paramMap);
        String whereSQL = updater.getWhereSQL(_table, (MapSO)paramMap);
        StringBuilder sql = new StringBuilder("update ").append(_table.getTable()).append(" set ");
        sql.append(fieldSQL);
        sql.append(whereSQL);
        return this.zSQL.executeUpdate(sql.toString(), paramMap, (MapSS)updater.getReplaceMap());
    }

    @Override
    public int update(_Table _table, LinkedMapSO data) throws ORMException, SQLException {
        return this.update(_table, data, (MapSS)new HashMapSS());
    }

    @Override
    public int updateMonth(_Table _table, LinkedMapSO data, String month) throws ORMException, SQLException {
        HashMapSS replaceMap = new HashMapSS();
        replaceMap.put("MONTH", month);
        return this.update(_table, data, (MapSS)replaceMap);
    }

    @Override
    public int update(_Table _table, LinkedMapSO data, String replaceKey, String replaceValue) throws ORMException, SQLException {
        HashMapSS replaceMap = new HashMapSS();
        replaceMap.put(replaceKey, replaceValue);
        return this.update(_table, data, (MapSS)replaceMap);
    }

    @Override
    public int update(_Table _table, LinkedMapSO data, MapSS replaceMap) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[update][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (_table.isAllKey()) {
            throw new ORMException("ZTabler[update][" + _table.getName() + "]\u6240\u6709\u5b57\u6bb5\u90fd\u662f\u5173\u952e\u5c5e\u6027,\u4e0d\u652f\u6301\u6b64\u66f4\u65b0\u65b9\u6cd5");
        }
        if (replaceMap == null) {
            throw new ORMException("ZTabler[update][\u53ef\u66ff\u6362\u8868\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, replaceMap);
        StringBuilder sql = new StringBuilder("update ").append(_table.getTable()).append(" set ");
        List<_TableField> fieldList = _table.getFieldListNoKey();
        _TableField field = fieldList.get(0);
        sql.append(field.getColumn()).append("=#").append(field.getColumn()).append("#");
        int i = 1;
        while (i < fieldList.size()) {
            field = fieldList.get(i);
            sql.append(", ").append(field.getColumn()).append("=#").append(field.getColumn()).append("#");
            ++i;
        }
        List<String> keyList = _table.getKeyList();
        StringBuilder where = new StringBuilder();
        where.append(" where ").append(keyList.get(0)).append("=#").append(keyList.get(0)).append("#");
        int i2 = 1;
        while (i2 < keyList.size()) {
            where.append(" and ").append(keyList.get(i2)).append("=#").append(keyList.get(i2)).append("#");
            ++i2;
        }
        sql.append((CharSequence)where);
        this.replaceFieldToColumn(data, _table);
        return this.zSQL.executeUpdate(sql.toString(), data, replaceMap);
    }

    @Override
    public int delete(_Table _table, Object ... ids) throws ORMException, SQLException {
        return this.delete(_table, null, ids);
    }

    @Override
    public int delete(_Table _table, MapSS replaceMap, Object ... ids) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[delete][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTabler[delete][" + _table.getName() + "]\u4f20\u53c2\u4e0e\u4e3b\u952e\u8981\u6c42\u4e0d\u5339\u914d]");
        }
        this.create(_table);
        StringBuilder sql = new StringBuilder("delete from ");
        String[] keyArr = _table.getKeyArr();
        sql.append(_table.getTable()).append(" where ").append(keyArr[0]).append("=?");
        int i = 1;
        while (i < keyArr.length) {
            sql.append(" and ").append(keyArr[i]).append("=?");
            ++i;
        }
        return this.zSQL.executeUpdate(sql.toString(), ids, replaceMap);
    }

    @Override
    public int delete(_Table _table, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTabler[delete][selector\u4e0d\u5141\u8bb8\u4e3anull]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[delete][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        StringBuilder sql = new StringBuilder("delete from ");
        sql.append(_table.getTable());
        sql.append(selector.getWhereSQL(_table, (MapSO)paramMap));
        return this.zSQL.executeUpdate(sql.toString(), paramMap, (MapSS)selector.getReplaceMap());
    }

    @Override
    public int[] deleteBatch(_Table _table, List<Object[]> idsList) throws ORMException, SQLException {
        return this.deleteBatch(_table, null, idsList);
    }

    @Override
    public int[] deleteBatch(_Table _table, MapSS replaceMap, List<Object[]> idsList) throws ORMException, SQLException {
        if (idsList == null || idsList.isEmpty()) {
            return new int[0];
        }
        if (_table == null) {
            throw new ORMException("ZTabler[delete][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        Object[] ids = idsList.get(0);
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTabler[delete][" + _table.getName() + "]\u4f20\u53c2\u4e0e\u4e3b\u952e\u8981\u6c42\u4e0d\u5339\u914d]");
        }
        this.create(_table);
        StringBuilder sql = new StringBuilder("delete from ");
        String[] keyArr = _table.getKeyArr();
        sql.append(_table.getTable()).append(" where ").append(keyArr[0]).append("=?");
        int i = 1;
        while (i < keyArr.length) {
            sql.append(" and ").append(keyArr[i]).append("=?");
            ++i;
        }
        return this.zSQL.executeBatch(sql.toString(), idsList, replaceMap);
    }

    @Override
    public int count(_Table _table, Object ... ids) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[count][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTabler[count][\u4f20\u53c2\u4e0e\u4e3b\u952e\u8981\u6c42\u4e0d\u5339\u914d]");
        }
        this.create(_table);
        StringBuilder sql = new StringBuilder("select count(*) from ").append(_table.getTable());
        String[] keyArr = _table.getKeyArr();
        sql.append(" where ").append(keyArr[0]).append("=?");
        int i = 1;
        while (i < keyArr.length) {
            sql.append(" and ").append(keyArr[i]).append("=?");
            ++i;
        }
        List<Integer> list = this.zSQL.executeQuery(sql.toString(), Integer.class, ids);
        return list.get(0);
    }

    @Override
    public int count(_Table _table) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[count][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table);
        String sql = "select count(*) from " + _table.getTable();
        List<Integer> list = this.zSQL.executeQuery(sql, Integer.class);
        return list.get(0);
    }

    @Override
    public int count(_Table _table, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTabler[count][selector\u4e0d\u5141\u8bb8\u4e3anull]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[count][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        StringBuilder sql = new StringBuilder("select count(*) from ").append(_table.getTable()).append(whereSQL);
        List<Integer> list = this.zSQL.executeQuery(sql.toString(), Integer.class, paramMap, (MapSS)selector.getReplaceMap());
        return list.get(0);
    }

    @Override
    public long sum(_Table _table, String field) throws ORMException, SQLException {
        return this.sum(_table, new Selector(), field);
    }

    @Override
    public long sum(_Table _table, Selector selector, String field) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[sum][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        String column = _table.getColumn(field);
        if (column == null) {
            throw new ORMException("ZTabler[sum][" + _table.getName() + "]\u914d\u7f6e\u4e2d\u672a\u627e\u5230[" + field + "]\u5b57\u6bb5");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        StringBuilder sql = new StringBuilder("select sum(").append(column).append(") from ").append(_table.getTable()).append(whereSQL);
        List<Long> list = this.zSQL.executeQuery(sql.toString(), Long.class, paramMap, (MapSS)selector.getReplaceMap());
        return list.isEmpty() ? 0L : list.get(0);
    }

    @Override
    public long[] sum(_Table _table, Selector selector, String ... fields) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTabler[sum][selector\u4e0d\u5141\u8bb8\u4e3anull]");
        }
        if (fields == null || fields.length < 1) {
            throw new ORMException("ZTabler[sum][fieldArr]\u4e0d\u80fd\u4e3a\u7a7a]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[sum][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!_table.hasAllField(fields)) {
            throw new ORMException("ZTabler[sum][" + Arrays.toString((String[])fields) + "]\u6709\u672a\u627e\u5230\u7684\u5b57\u6bb5");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        StringBuilder sql = new StringBuilder("select ");
        String column = _table.getColumn(fields[0]);
        sql.append(" sum(").append(column).append(") as ").append(fields[0]);
        int i = 1;
        while (i < fields.length) {
            column = _table.getColumn(fields[i]);
            sql.append(", sum(").append(column).append(") as ").append(fields[i]);
            ++i;
        }
        HashMapSO paramMap = new HashMapSO();
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        sql.append(" from ").append(_table.getTable()).append(whereSQL);
        List<LinkedMapSO> list = this.zSQL.executeQuery(sql.toString(), LinkedMapSO.class, paramMap, (MapSS)selector.getReplaceMap());
        if (list.isEmpty()) {
            return new long[fields.length];
        }
        LinkedMapSO item = list.get(0);
        long[] valueArr = new long[fields.length];
        int i2 = 0;
        while (i2 < fields.length) {
            BigDecimal value = (BigDecimal)item.get(fields[i2]);
            valueArr[i2] = value == null ? 0L : value.longValue();
            ++i2;
        }
        return valueArr;
    }

    @Override
    public LinkedMapSO item(_Table _table, Object ... ids) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[item][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        if (!_table.isValidKeyObj(ids)) {
            throw new ORMException("ZTabler[item][" + _table.getName() + "]\u4f20\u53c2\u4e0e\u4e3b\u952e\u8981\u6c42\u4e0d\u5339\u914d]");
        }
        this.create(_table);
        StringBuilder sql = new StringBuilder("select * from ").append(_table.getTable());
        String[] keyArr = _table.getKeyArr();
        sql.append(" where ").append(keyArr[0]).append("=?");
        int i = 1;
        while (i < keyArr.length) {
            sql.append(" and ").append(keyArr[i]).append("=?");
            ++i;
        }
        List<LinkedMapSO> list = this.zSQL.executeQuery(sql.toString(), LinkedMapSO.class, ids);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public LinkedMapSO item(_Table _table) throws ORMException, SQLException {
        return this.item(_table, new Selector());
    }

    @Override
    public LinkedMapSO item(_Table _table, Selector selector) throws ORMException, SQLException {
        if (_table == null) {
            throw new ORMException("ZTabler[item][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String fieldSQL = selector.getFieldSQL(_table);
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_table);
        String groupbySQL = selector.getGroupbySQL(_table);
        String sql = this.server.getPolicy().toItemSQL(fieldSQL, _table.getTable(), whereSQL, orderbySQL, groupbySQL);
        List<LinkedMapSO> list = this.zSQL.executeQuery(sql, LinkedMapSO.class, paramMap, (MapSS)selector.getReplaceMap());
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public List<LinkedMapSO> list(_Table _table) throws ORMException, SQLException {
        return this.list(_table, new Selector());
    }

    @Override
    public List<LinkedMapSO> list(_Table _table, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTabler[list][Selector\u4e0d\u5141\u8bb8\u4e3anull]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[list][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String fieldSQL = selector.getFieldSQL(_table);
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_table);
        String groupbySQL = selector.getGroupbySQL(_table);
        StringBuilder sql = new StringBuilder("select ").append(fieldSQL).append(" from ").append(_table.getTable()).append(whereSQL).append(orderbySQL).append(groupbySQL);
        return this.zSQL.executeQuery(sql.toString(), LinkedMapSO.class, paramMap, (MapSS)selector.getReplaceMap());
    }

    @Override
    public List<LinkedMapSO> list(_Table _table, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.list(_table, pageNo, pageSize, new Selector());
    }

    @Override
    public List<LinkedMapSO> list(_Table _table, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZTabler[list][Selector\u4e0d\u5141\u8bb8\u4e3anull]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[list][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        return this.lister(_table, pageNo, pageSize, selector);
    }

    @Override
    public PageResult<LinkedMapSO> page(_Table _table, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.page(_table, pageNo, pageSize, new Selector());
    }

    @Override
    public PageResult<LinkedMapSO> page(_Table _table, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        int totalRecord;
        if (selector == null) {
            throw new ORMException("ZTabler[page][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        if (_table == null) {
            throw new ORMException("ZTabler[page][\u8868\u5b9a\u4e49\u5bf9\u8c61\u4e0d\u80fd\u4e3anull]");
        }
        this.create(_table, (MapSS)selector.getReplaceMap());
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if ((totalRecord = this.count(_table, selector)) == 0) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        int maxPage = (totalRecord - 1) / pageSize + 1;
        if (pageNo > maxPage) {
            pageNo = maxPage;
        }
        List<LinkedMapSO> list = this.lister(_table, pageNo, pageSize, selector);
        return PageBuilder.newResult((int)totalRecord, (int)pageNo, (int)pageSize, list);
    }

    @Override
    public String toInsertOrReplaceSQL(_Table _table, String statement) {
        StringBuilder sql = new StringBuilder(statement).append(" into ").append(_table.getTable()).append("(");
        StringBuilder values = new StringBuilder("values (");
        List<_TableField> fieldList = _table.getFieldList();
        for (_TableField field : fieldList) {
            sql.append(field.getColumn()).append(",");
            values.append("#").append(field.getColumn()).append("#").append(",");
        }
        sql.setLength(sql.length() - 1);
        values.setLength(values.length() - 1);
        sql.append(") ").append((CharSequence)values).append(")");
        return sql.toString();
    }

    private String toInsertOrUpdateSQL(_Table _table, LinkedMapSO data, MapSO paramMap) throws ORMException {
        StringBuilder sql = new StringBuilder("insert into ").append(_table.getTable()).append("(");
        StringBuilder values = new StringBuilder("values (");
        List<_TableField> fieldList = _table.getFieldList();
        for (_TableField field : fieldList) {
            String column = field.getColumn();
            paramMap.put(column, data.get(column));
            sql.append(column).append(",");
            values.append("#").append(column).append("#").append(",");
        }
        sql.setLength(sql.length() - 1);
        values.setLength(values.length() - 1);
        sql.append(") ").append((CharSequence)values).append(")");
        return sql.toString();
    }

    @Override
    public String toUpdateFieldSQL(_Table _table, Updater updater, MapSO paramMap) throws ORMException {
        StringBuilder sql = new StringBuilder();
        for (UpdaterField field : updater.getFieldList().values()) {
            _TableField[] dboFieldArr;
            if (!_table.hasField(field.getField())) {
                throw new ORMException("ZTabler[toUpdateFieldSQL][" + _table.getName() + "]\u914d\u7f6e\u4e2d\u672a\u627e\u5230[" + field.getField() + "]\u5b57\u6bb5");
            }
            String column = _table.getColumn(field.getField());
            if (field.getType() == 0) {
                paramMap.put(column, field.getValue());
                sql.append(column).append("=#").append(column).append("#,");
                continue;
            }
            String value = (String)field.getValue();
            _TableField[] _TableFieldArray = dboFieldArr = _table.getFieldColumnListOrderByLen();
            int n = dboFieldArr.length;
            int n2 = 0;
            while (n2 < n) {
                _TableField dboField = _TableFieldArray[n2];
                value = value.replaceAll(dboField.getField(), dboField.getColumn());
                ++n2;
            }
            sql.append(column).append("=").append(value).append(",");
        }
        if (sql.length() > 0) {
            sql.setLength(sql.length() - 1);
        }
        return sql.toString();
    }

    private List<LinkedMapSO> lister(_Table _table, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        int minNum = (pageNo - 1) * pageSize + 1;
        int maxNum = pageNo * pageSize;
        HashMapSO paramMap = new HashMapSO();
        paramMap.put("minNum", (Object)minNum);
        paramMap.put("maxNum", (Object)maxNum);
        paramMap.put("minSize", (Object)(minNum - 1));
        paramMap.put("pageSize", (Object)pageSize);
        String fieldSQL = selector.getFieldSQL(_table);
        String whereSQL = selector.getWhereSQL(_table, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_table);
        String groupbySQL = selector.getGroupbySQL(_table);
        String sql = this.server.getPolicy().toPageSQL(fieldSQL, _table.getTable(), whereSQL, orderbySQL, groupbySQL, maxNum, pageNo);
        return this.zSQL.executeQuery(sql, LinkedMapSO.class, paramMap, (MapSS)selector.getReplaceMap());
    }

    private void replaceFieldToColumn(LinkedMapSO data, _Table _table) {
        String[] keys;
        String[] stringArray = keys = (String[])Lists.toArray((Collection)data.keySet(), (Object[])new String[0]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String column = _table.getColumn(key);
            Asserts.assertNotNull((Object)column, (String)ORMI18n.ormTableNotFoundField2, (Object[])new Object[]{_table.getName(), key});
            if (!column.equals(key)) {
                data.put(column, data.get(key));
                data.remove(key);
            }
            ++n2;
        }
    }
}

