/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZResultSet;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.executor.QueryExecutor;

public class QueryExecutorBaseBase
implements QueryExecutor {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<?> execute(ORMServer server, Connection conn, String sql, Class<?> resultClass, Object param, MapSS replaceMap) throws ORMException, SQLException {
        List<?> list;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String str = null;
        try {
            sql = Sqls.formatReplaceMap((String)sql, (MapSS)replaceMap);
            if (server.isQuerySqlLog()) {
                str = sql;
            }
            pstmt = conn.prepareStatement(sql);
            if (Types.isArray((Object)param)) {
                Object[] objs = Arrays.toArray((Object)param);
                int i = 0;
                while (i < objs.length) {
                    if (server.isQuerySqlLog()) {
                        str = ZStatement.setParameter(server, pstmt, i + 1, objs[i], str);
                    } else {
                        ZStatement.setParameter(server, pstmt, i + 1, objs[i]);
                    }
                    ++i;
                }
            } else if (param != null) {
                if (server.isQuerySqlLog()) {
                    str = ZStatement.setParameter(server, pstmt, 1, param, str);
                } else {
                    ZStatement.setParameter(server, pstmt, 1, param);
                }
            }
            if (server.isQuerySqlLog()) {
                str = str.replaceAll("-%6-%-3%-", "?");
                qSqlLog.info((Object)str);
            }
            rst = pstmt.executeQuery();
            list = ZResultSet.parseToBase(rst, resultClass);
        }
        catch (SQLException e) {
            try {
                log.error((Object)"QueryExecutorBaseBase[SQLException][%s][sql=%s]", (Throwable)e, new Object[]{e.getMessage(), sql});
                throw e;
                catch (Exception e2) {
                    log.error((Object)"QueryExecutorBaseBase[Exception][%s]", (Throwable)e2, new Object[]{e2.getMessage()});
                    throw new ORMException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ZDBClose.close(rst, pstmt);
                throw throwable;
            }
        }
        ZDBClose.close(rst, pstmt);
        return list;
    }
}

