/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.executor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.SS;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.executor.BatchExecutor;

public class BatchExecutorClass
implements BatchExecutor {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] execute(ORMServer server, Connection conn, String sql, List<?> paramList, MapSS replaceMap) throws ORMException, SQLException {
        int[] nArray;
        PreparedStatement pstmt = null;
        ArrayList<String> strList = null;
        try {
            String method;
            sql = Sqls.formatReplaceMap((String)sql, (MapSS)replaceMap);
            Class<?> dboClass = paramList.get(0).getClass();
            Dbo paramDbo = server.getDbo(dboClass);
            ArrayList<SS> paramKeyList = new ArrayList<SS>();
            int i = 0;
            int start = 0;
            int end = sql.indexOf(35);
            while (end != -1) {
                if (i % 2 != 0) {
                    String paramKey = sql.substring(start + 1, end);
                    method = paramDbo.getGetMethod(paramKey);
                    if (method == null) {
                        throw new ORMException("ZTable/ZView[" + paramDbo.getClass().getName() + "]\u6ca1\u6709\u627e\u5230" + paramKey + "\u5bf9\u5e94\u7684\u65b9\u6cd5]");
                    }
                    paramKeyList.add(new SS(paramKey, method));
                }
                ++i;
                start = end;
                end = sql.indexOf(35, start + 1);
            }
            i = 0;
            while (i < paramKeyList.size()) {
                String paramKey = ((SS)paramKeyList.get(i)).key();
                sql = sql.replaceAll("#" + paramKey + "#", "?");
                ++i;
            }
            if (server.isUpdateSqlLog()) {
                strList = new ArrayList<String>(paramList.size());
                i = 0;
                while (i < paramList.size()) {
                    strList.add(sql);
                    ++i;
                }
            }
            pstmt = conn.prepareStatement(sql);
            int b = 0;
            while (b < paramList.size()) {
                String str = null;
                if (server.isUpdateSqlLog()) {
                    str = (String)strList.get(b);
                }
                Object obj = paramList.get(b);
                int i2 = 0;
                while (i2 < paramKeyList.size()) {
                    method = ((SS)paramKeyList.get(i2)).value();
                    Method m = dboClass.getMethod(method, new Class[0]);
                    Object value = m.invoke(obj, new Object[0]);
                    if (server.isUpdateSqlLog()) {
                        str = ZStatement.setParameter(server, pstmt, i2 + 1, value, str);
                    } else {
                        ZStatement.setParameter(server, pstmt, i2 + 1, value);
                    }
                    ++i2;
                }
                pstmt.addBatch();
                if (server.isUpdateSqlLog()) {
                    strList.remove(b);
                    strList.add(b, str);
                }
                ++b;
            }
            int[] rets = pstmt.executeBatch();
            if (server.isUpdateSqlLog()) {
                for (String str : strList) {
                    str = str.replaceAll("-%6-%-3%-", "?");
                    uSqlLog.info((Object)str);
                }
            }
            nArray = rets;
        }
        catch (SQLException e) {
            try {
                log.error((Object)"BatchExecutorClass[SQLException][%s][sql=%s]", (Throwable)e, new Object[]{e.getMessage(), sql});
                throw e;
                catch (Exception e2) {
                    log.error((Object)"BatchExecutorClass[Exception][%s]", (Throwable)e2, new Object[]{e2.getMessage()});
                    throw new ORMException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ZDBClose.close(pstmt);
                throw throwable;
            }
        }
        ZDBClose.close(pstmt);
        return nArray;
    }
}

