/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.dbo.defined;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.orm.dbo.UpdaterField;
import org.zhiqim.orm.dbo.condition._Compare;
import org.zhiqim.orm.dbo.condition._In;
import org.zhiqim.orm.dbo.condition._InNot;
import org.zhiqim.orm.dbo.condition._IsNotNull;
import org.zhiqim.orm.dbo.condition._IsNull;
import org.zhiqim.orm.dbo.condition._Or;
import org.zhiqim.orm.dbo.defined._TableField;
import org.zhiqim.orm.dbo.defined._TableIndex;
import org.zhiqim.orm.dbo.defined._TableReplace;

public class _Table
implements Dbo,
ORMConstants {
    private String name;
    private String table;
    private String key;
    private String type;
    private List<_TableIndex> indexList = new ArrayList<_TableIndex>();
    private List<_TableReplace> replaceList = new ArrayList<_TableReplace>();
    private LinkedMapSV<_TableField> fieldMap = new LinkedMapSV();
    private LinkedMapSV<_TableField> columnMap = new LinkedMapSV();

    public _Table(String table, String key) {
        this(table, table, key, "");
    }

    public _Table(String table, String key, String type) {
        this(table, table, key, type);
    }

    public _Table(String name, String table, String key, String type) {
        this.name = name;
        this.table = table;
        this.type = type;
        if (Validates.isNotEmptyBlank((String)key)) {
            this.key = key.toUpperCase();
        }
    }

    public void addIndex(String name, String column, boolean unique) {
        _TableIndex index = new _TableIndex(name, column.toUpperCase(), unique);
        this.indexList.add(index);
    }

    public void addIndex(String column, boolean unique) {
        _TableIndex index = new _TableIndex("IX_" + this.table, column.toUpperCase(), unique);
        this.indexList.add(index);
    }

    public void addReplace(String name, String column) {
        this.replaceList.add(new _TableReplace(name, column));
    }

    public void addField(String field, String column, String type, boolean notNull) {
        _TableField tField = new _TableField(field, column.toUpperCase(), type, notNull);
        this.fieldMap.put(field, (Object)tField);
        this.columnMap.put(column.toUpperCase(), (Object)tField);
    }

    public void addField(String column, String type, boolean notNull) {
        String field = ORMType.toLowerName(column);
        _TableField tField = new _TableField(field, column.toUpperCase(), type, notNull);
        this.fieldMap.put(field, (Object)tField);
        this.columnMap.put(column.toUpperCase(), (Object)tField);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder("    ").append("<table").append(" name=").append('\"').append(this.name).append('\"').append(" table=").append('\"').append(this.table).append('\"').append(" key=").append('\"').append(this.key).append('\"').append(" type=").append('\"').append(this.type).append('\"').append(">").append("\r\n");
        for (_TableIndex index : this.indexList) {
            strb.append("    ").append("    ").append(index).append("\r\n");
        }
        strb.append("\r\n");
        for (_TableField field : this.fieldMap.values()) {
            strb.append("    ").append("    ").append(field).append("\r\n");
        }
        strb.append("    ").append("</table>");
        return strb.toString();
    }

    @Override
    public boolean hasEqualJoin() {
        return false;
    }

    @Override
    public String getGetMethod(String field) {
        _TableField tField = this.getField(field);
        return tField == null ? null : tField.getGetMethod();
    }

    public String getSetMethod(String field) {
        _TableField tField = this.getField(field);
        return tField == null ? null : tField.getSetMethod();
    }

    @Override
    public String getColumn(String field) {
        _TableField tField = this.getField(field);
        return tField == null ? null : tField.getColumn();
    }

    @Override
    public _TableField getField(String field) {
        _TableField tField = (_TableField)this.fieldMap.get(field);
        if (tField == null) {
            tField = (_TableField)this.columnMap.get(field.toUpperCase());
        }
        return tField;
    }

    @Override
    public boolean hasField(String field) {
        return this.fieldMap.containsKey(field) ? true : this.columnMap.containsKey(field.toUpperCase());
    }

    public List<_TableField> getFieldList() {
        return new ArrayList<_TableField>(this.fieldMap.values());
    }

    public List<_TableField> getFieldListNoKey() {
        List<String> keyList = this.getKeyList();
        ArrayList<_TableField> fieldList = new ArrayList<_TableField>();
        for (_TableField field : this.fieldMap.values()) {
            if (keyList.contains(field.getColumn())) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    public _TableField[] getFieldColumnListOrderByLen() {
        _TableField[] array = new _TableField[this.fieldMap.size()];
        int index = 0;
        for (_TableField field : this.fieldMap.values()) {
            array[index++] = field;
        }
        int i = 0;
        while (i < array.length) {
            int j = i + 1;
            while (j < array.length) {
                if (array[i].getField().length() < array[j].getField().length()) {
                    _TableField v = array[i];
                    array[i] = array[j];
                    array[j] = v;
                }
                ++j;
            }
            ++i;
        }
        return array;
    }

    public boolean hasAllField(String[] fieldArr) {
        String[] stringArray = fieldArr;
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (!this.fieldMap.containsKey(field)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isValidKey() {
        if (Validates.isEmptyBlank((String)this.key)) {
            return false;
        }
        String[] keyArr = Arrays.toStringArray((String)this.key, (String)",");
        String ck = null;
        String[] stringArray = keyArr;
        int n = keyArr.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            if (k.equals(ck)) {
                return false;
            }
            if (!this.columnMap.containsKey(k)) {
                return false;
            }
            ck = k;
            ++n2;
        }
        return true;
    }

    public boolean isValidKeyObj(Object[] objArr) {
        String[] keyArr = this.getKeyArr();
        if (keyArr.length != objArr.length) {
            return false;
        }
        int[] typeArr = new int[keyArr.length];
        int i = 0;
        while (i < keyArr.length) {
            _TableField field = (_TableField)this.columnMap.get(keyArr[i]);
            typeArr[i] = field.getType();
            ++i;
        }
        i = 0;
        while (i < typeArr.length) {
            int type = typeArr[i];
            Object obj = objArr[i];
            if (!this.isValidField(type, obj)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String isValidSelector(Selector selector) {
        if (selector == null || Validates.isEmpty((Collection)selector.getConditionList())) {
            return null;
        }
        return this.isValidCondition(selector.getConditionList());
    }

    public String isValidUpdater(Updater updater) {
        if (updater == null || Validates.isEmpty((Collection)updater.getConditionList())) {
            return null;
        }
        String result = this.isValidCondition(updater.getConditionList());
        if (result != null) {
            return result;
        }
        for (UpdaterField field : updater.getFieldList().values()) {
            if (field.getType() == 1 || this.isValidUpdaterValue(field.getField(), field.getValue())) continue;
            return field.getField();
        }
        return null;
    }

    private boolean isValidUpdaterValue(String field, Object value) {
        _TableField f = (_TableField)this.fieldMap.get(field);
        if (f == null) {
            return false;
        }
        if (!f.isNotNull() && value == null) {
            return true;
        }
        return this.isValidField(f.getType(), value);
    }

    private String isValidCondition(List<Condition> cList) {
        for (Condition c : cList) {
            _Or or;
            String result;
            Condition in;
            if (c instanceof _IsNull || c instanceof _IsNotNull) continue;
            if (c instanceof _Compare) {
                _Compare _c = (_Compare)c;
                if (this.isValidCondition(_c.getField(), _c.getValue())) continue;
                return _c.getField();
            }
            if (c instanceof _In) {
                in = (_In)c;
                if (this.isValidFieldIn(((_In)in).getField(), ((_In)in).getValue())) continue;
                return ((_In)in).getField();
            }
            if (c instanceof _InNot) {
                in = (_InNot)c;
                if (this.isValidFieldIn(((_InNot)in).getField(), ((_InNot)in).getValue())) continue;
                return ((_InNot)in).getField();
            }
            if (!(c instanceof _Or) || (result = this.isValidCondition((or = (_Or)c).getCondition())) == null) continue;
            return result;
        }
        return null;
    }

    private boolean isValidCondition(String field, Object value) {
        _TableField f = (_TableField)this.fieldMap.get(field);
        return f == null ? false : this.isValidField(f.getType(), value);
    }

    private boolean isValidField(int type, Object value) {
        switch (type) {
            case 4: {
                return value instanceof Boolean;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return value instanceof Integer || value instanceof Long;
            }
            case 7: {
                return value instanceof Timestamp;
            }
            case 8: {
                return value instanceof Double;
            }
            case 1: {
                return value instanceof String;
            }
            case 9: {
                return value instanceof byte[];
            }
        }
        return false;
    }

    private boolean isValidFieldIn(String field, Object value) {
        _TableField f = (_TableField)this.fieldMap.get(field);
        if (f == null) {
            return false;
        }
        switch (f.getType()) {
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                return value instanceof int[] || value instanceof Integer[] || value instanceof long[] || value instanceof Long[];
            }
            case 8: {
                return value instanceof double[] || value instanceof Double[];
            }
            case 1: {
                return value instanceof String[];
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getTable() {
        return this.table;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getKeyArr() {
        return Arrays.toStringArray((String)this.key, (String)",");
    }

    public String[] getKeyFieldArr() {
        String[] keys = this.getKeyArr();
        if (keys.length == 0) {
            return keys;
        }
        String[] fields = new String[keys.length];
        int i = 0;
        while (i < fields.length) {
            fields[i] = ((_TableField)this.columnMap.get(keys[i])).getField();
            ++i;
        }
        return fields;
    }

    public List<String> getKeyList() {
        return Lists.toStringList((String)this.key, (String)",");
    }

    public boolean isAllKey() {
        return Arrays.toStringArray((String)this.key, (String)",").length == this.fieldMap.size();
    }

    public List<_TableIndex> getIndexList() {
        return this.indexList;
    }

    public void chkReplace(MapSS replaceMap) {
        if (this.replaceList.isEmpty()) {
            return;
        }
        if (!replaceMap.isEmpty()) {
            ArrayList<_TableReplace> list = new ArrayList<_TableReplace>();
            for (String field : replaceMap.keySet()) {
                _TableReplace replace = this.getReplaceColumn(field);
                if (replace == null) continue;
                list.add(replace);
            }
            for (_TableReplace replace : list) {
                String value = replaceMap.remove(replace.getField());
                replaceMap.put(replace.getColumn(), value == null ? "" : value);
            }
        }
        for (_TableReplace replace : this.replaceList) {
            if (replaceMap.containsKey(replace.getColumn())) continue;
            replaceMap.put(replace.getColumn(), "");
        }
    }

    public void addReplaceToMap(Object data, MapSS replaceMap) {
        if (this.replaceList.isEmpty()) {
            return;
        }
        for (_TableReplace replace : this.replaceList) {
            Object val = Classes.getFieldValue((Object)data, (String)replace.getField());
            replaceMap.put(replace.getColumn(), val == null ? "" : String.valueOf(val));
        }
    }

    public void addReplaceToData(Object data, MapSS replaceMap) {
        if (this.replaceList.isEmpty()) {
            return;
        }
        for (_TableReplace replace : this.replaceList) {
            Field field;
            String value = replaceMap.get(replace.getColumn());
            if (value == null || (field = Classes.getFieldDeep(data.getClass(), (String)replace.getField())) == null) continue;
            Classes.setFieldValue((Object)data, (Field)field, (Object)value);
        }
    }

    private _TableReplace getReplaceColumn(String field) {
        for (_TableReplace replace : this.replaceList) {
            if (!replace.getField().equals(field)) continue;
            return replace;
        }
        return null;
    }
}

