/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.control.ThreadLock;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.seqs.Sequence;
import org.zhiqim.orm.datasource.ZConnection;
import org.zhiqim.orm.datasource.ZConnectionTester;

public class ZDataSource
extends Threadx
implements DataSource,
Runnable,
SignConstants {
    private static final Log log = LogFactory.getLog((String)"database.log");
    private static final String JNDI = "jndi";
    private static final int CHK_TIME = 60000;
    private final String id;
    private final Sequence sequence = new Sequence(6);
    private final ThreadLock lock = new ThreadLock();
    private final List<ZConnection> connList;
    private final ConcurrentHashMap<ZConnection, String> closedMap;
    private final AtomicInteger activeSize;
    private String driver;
    private String url;
    private String user;
    private String pass;
    private int level;
    private int minPoolSize;
    private int maxPoolSize;
    private long maxKeepTimeMs;
    private long maxIdleTimeMs;
    private boolean isChkConnOnTimer;
    private boolean isChkConnOnGet;
    private boolean isChkConnOnRelease;
    private int outOfConnWaitTimeMs;
    private int outOfConnRetryCount;
    private boolean isDbBreak;
    private ZConnectionTester tester;

    public ZDataSource(String id, String driver, String url, String user, String pass, int minPoolSize, int maxPoolSize, int maxKeepTime) {
        this(id, driver, url, user, pass, -1, minPoolSize, maxPoolSize, maxKeepTime, maxKeepTime, true, false, false, 5, 1);
    }

    public ZDataSource(String id, String driver, String url, String user, String pass, int level, int minPoolSize, int maxPoolSize, int maxKeepTime, int maxIdleTime, boolean isChkConnOnTimer, boolean isChkConnOnGet, boolean isChkConnOnRelease, int outOfConnWaitTime, int outOfConnRetryCount) {
        this.id = id != null ? id : Randoms.lettersDigits((int)2);
        this.connList = new LinkedList<ZConnection>();
        this.closedMap = new ConcurrentHashMap();
        this.activeSize = new AtomicInteger(0);
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.pass = pass;
        this.level = level;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.maxKeepTimeMs = maxKeepTime * 1000;
        this.maxIdleTimeMs = maxIdleTime * 1000;
        this.isChkConnOnTimer = isChkConnOnTimer;
        this.isChkConnOnGet = isChkConnOnGet;
        this.isChkConnOnRelease = isChkConnOnRelease;
        this.outOfConnWaitTimeMs = outOfConnWaitTime * 1000;
        this.outOfConnRetryCount = outOfConnRetryCount;
    }

    public String toString() {
        return "\u6570\u636e\u5e93[" + "id:" + this.id + "," + "min:" + this.minPoolSize + "," + "max:" + this.maxPoolSize + "," + "cur:" + this.getConnSize() + "," + "active:" + this.activeSize.get() + "," + "mKeep:" + this.maxKeepTimeMs / 1000L + "," + "mIdle:" + this.maxIdleTimeMs / 1000L + "," + "isTimer:" + this.isChkConnOnTimer + "," + "isGet:" + this.isChkConnOnGet + "," + "isRelease:" + this.isChkConnOnRelease + "," + "outWait:" + this.outOfConnWaitTimeMs / 1000 + "," + "outRetry:" + this.outOfConnRetryCount + "]";
    }

    protected String getThreadName() {
        return "ZDataSource-" + this.id;
    }

    protected boolean openBefore() {
        if (!this.createConnectionTester()) {
            return false;
        }
        this.deleteConnections();
        return this.createConnections("\u521d\u59cb\u5316");
    }

    protected void closeAfter() {
        this.deleteConnections();
        this.tester.shutdown();
        log.info((Object)"\u6570\u636e\u5e93[%s]\u76d1\u89c6\u7ebf\u7a0b\u9000\u51fa", new Object[]{this.id});
    }

    protected void first() {
        Threads.sleepIgnoreException((int)60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() {
        log.info((Object)this.toString());
        Iterator it = this.closedMap.keySet().iterator();
        while (it.hasNext()) {
            ZConnection conn = (ZConnection)it.next();
            conn.shutdown();
            it.remove();
            log.info((Object)"\u76d1\u89c6\u5173\u95ed\u6570\u636e\u5e93\u7b49\u5f85\u5173\u95ed\u7684\u8fde\u63a5[%s][%s]\u6210\u529f", new Object[]{this.id, conn.getId()});
        }
        this.isDbBreak = this.tester.isDbBreak();
        if (this.isDbBreak) {
            this.deleteConnections();
            return;
        }
        List list = Lists.copy(this.connList, (boolean)true);
        for (ZConnection conn : list) {
            if (conn.isActive() || !conn.isClosed() && !conn.isKeepOrIdleTimeout() && (!this.isChkConnOnTimer || conn.isConnectionAvailable())) continue;
            List<ZConnection> list2 = this.connList;
            synchronized (list2) {
                this.connList.remove(conn);
            }
            String connId = conn.getId();
            conn.shutdown();
            conn = null;
            log.info((Object)"\u76d1\u89c6\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5[%s][%s]\u6210\u529f", new Object[]{this.id, connId});
        }
        this.createConnections("\u8865\u8db3");
        Threads.sleepIgnoreException((int)60000);
    }

    private boolean createConnectionTester() {
        block5: {
            if (this.tester != null) {
                this.tester.shutdown();
                this.tester = null;
            }
            try {
                Class cls;
                if (JNDI.equalsIgnoreCase(this.driver) || (cls = Classes.forName((String)this.driver)) != null) break block5;
                log.error((Object)"\u6570\u636e\u5e93[%s]\u521d\u59cb\u5316\u5931\u8d25\uff0c\u672a\u627e\u5230\u9a71\u52a8\u7c7b[%s]", new Object[]{this.id, this.driver});
                return false;
            }
            catch (Exception e) {
                log.error((Object)"\u6570\u636e\u5e93[%s]\u521d\u59cb\u5316\u5931\u8d25\uff0c%s", new Object[]{this.id, e.getMessage()});
                return false;
            }
        }
        this.tester = new ZConnectionTester(this);
        if (this.tester.isDbBreak()) {
            log.error((Object)"\u6570\u636e\u5e93[%s]\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8fde\u63a5\u65ad\u5f00", new Object[]{this.id});
            return false;
        }
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(int times) throws SQLException {
        List<ZConnection> list = this.connList;
        synchronized (list) {
            ZConnection conn;
            Iterator<ZConnection> it = this.connList.iterator();
            while (it.hasNext()) {
                ZConnection conn2 = it.next();
                if (conn2.isActive()) continue;
                if (conn2.isClosed() || conn2.isKeepOrIdleTimeout() || this.isChkConnOnGet && !conn2.isConnectionAvailable()) {
                    this.closedMap.put(conn2, "");
                    it.remove();
                    continue;
                }
                return conn2.active();
            }
            if (this.connList.size() < this.maxPoolSize && (conn = this.newProxyConnection("\u83b7\u53d6")) != null) {
                this.connList.add(conn);
                return conn.active();
            }
        }
        this.lock.lock((long)this.outOfConnWaitTimeMs);
        list = this.connList;
        synchronized (list) {
            for (ZConnection conn : this.connList) {
                if (conn.isActive()) continue;
                return conn.active();
            }
        }
        String fatal = "\u6570\u636e\u5e93\u8fde\u63a5[" + this.id + "]\u8fde\u63a5\u8017\u5c3d\uff0c[max:" + this.getMaxPoolSize() + ",cur:" + this.getConnSize() + ",active:" + this.activeSize.get() + "]";
        if (times < this.outOfConnRetryCount) {
            log.fatal((Object)"%s[\u7b2c%s]", new Object[]{fatal, times + 1});
            return this.getConnection(times + 1);
        }
        log.fatal((Object)"%s[\u7b2c%s][\u5168\u90e8\u5931\u8d25\u629b\u51fa\u5f02\u5e38\u5230\u4e1a\u52a1\u5c42]", new Object[]{fatal, times + 1});
        throw new SQLException("\u6570\u636e\u5e93\u8fde\u63a5\u8017\u5c3d\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u68c0\u67e5\u6570\u636e\u5e93\u662f\u5426\u6b63\u5e38\u5de5\u4f5c\u548c\u8fde\u63a5\u6c60\u914d\u7f6e\u662f\u5426\u8db3\u591f!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(ZConnection conn) {
        if (conn == null) {
            return;
        }
        if (conn.isClosed() || conn.isKeepOrIdleTimeout() || this.isChkConnOnRelease && !conn.isConnectionAvailable()) {
            String connId = conn.getId();
            conn.shutdown();
            List<ZConnection> list = this.connList;
            synchronized (list) {
                this.connList.remove(conn);
            }
            conn = null;
            log.info((Object)"\u91ca\u653e\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5[%s][%s]\u6210\u529f", new Object[]{this.id, connId});
            return;
        }
        conn.idle();
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createConnections(String type) {
        int num = this.minPoolSize - this.connList.size();
        int i = 0;
        while (i < num) {
            ZConnection conn = this.newProxyConnection(type);
            if (conn == null) {
                return false;
            }
            List<ZConnection> list = this.connList;
            synchronized (list) {
                this.connList.add(conn);
            }
            ++i;
        }
        if (num > 0) {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConnections() {
        List<ZConnection> list = this.connList;
        synchronized (list) {
            Iterator<ZConnection> it = this.connList.iterator();
            while (it.hasNext()) {
                ZConnection conn = it.next();
                String connId = conn.getId();
                conn.shutdown();
                it.remove();
                conn = null;
                log.info((Object)"\u9500\u6bc1\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5[%s][%s]\u6210\u529f", new Object[]{this.id, connId});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ZConnection newProxyConnection(String type) {
        try {
            Connection conn = null;
            if (JNDI.equalsIgnoreCase(this.driver)) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(this.url);
                if (dataSource == null) {
                    return null;
                }
                dataSource.setLoginTimeout(10);
                conn = dataSource.getConnection();
            } else {
                DriverManager.setLoginTimeout(10);
                conn = DriverManager.getConnection(this.url, this.user, this.pass);
            }
            if (conn == null) {
                log.error((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s]\u5931\u8d25\uff0c[%s]", new Object[]{this.id, type});
                return null;
            }
            ZConnection connection = new ZConnection(this, conn);
            if (this.level == 0 || this.level == 1 || this.level == 2 || this.level == 4 || this.level == 8) {
                connection.setTransactionIsolation(this.level);
            }
            log.info((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s][%s]\u6210\u529f\uff0c[%s]", new Object[]{this.id, connection.getId(), type});
            return connection;
        }
        catch (SQLException e) {
            log.error((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s]\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff1a[%s]", new Object[]{this.id, e.getMessage()});
            return null;
        }
        catch (Exception e) {
            log.error((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s]\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff1a[%s]", new Object[]{this.id, e.getMessage()});
            return null;
        }
    }

    void active() {
        this.activeSize.getAndIncrement();
    }

    void idle() {
        this.activeSize.getAndDecrement();
    }

    public int getConnSize() {
        return this.connList.size();
    }

    public int getConnActiveSize() {
        return this.activeSize.get();
    }

    public boolean isDbBreak() {
        return this.tester.isDbBreak();
    }

    public String nextSequence() {
        return this.sequence.nextString();
    }

    public String getId() {
        return this.id;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getMaxKeepTimeMs() {
        return this.maxKeepTimeMs;
    }

    public long getMaxIdleTimeMs() {
        return this.maxIdleTimeMs;
    }

    public boolean isChkConnOnTimer() {
        return this.isChkConnOnTimer;
    }

    public boolean isChkConnOnGet() {
        return this.isChkConnOnGet;
    }

    public boolean isChkConnOnRelease() {
        return this.isChkConnOnRelease;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMaxKeepTime(long maxKeepTime) {
        this.maxKeepTimeMs = maxKeepTime * 1000L;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTimeMs = maxIdleTime * 1000L;
    }

    public void setChkConnOnTimer(boolean isChkConnOnTimer) {
        this.isChkConnOnTimer = isChkConnOnTimer;
    }

    public void setChkConnOnGet(boolean isChkConnOnGet) {
        this.isChkConnOnGet = isChkConnOnGet;
    }

    public void setChkConnOnRelease(boolean isChkConnOnRelease) {
        this.isChkConnOnRelease = isChkConnOnRelease;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("\u4e0d\u652f\u6301\u4f20\u5165\u7528\u6237\u540d\u548c\u5bc6\u7801\u83b7\u53d6\u8fde\u63a5");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

