/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.presenter;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Images;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

/**
 * 管理台头像控制器
 *
 * @version v1.0.0 @author zouzhigang 2017-6-6 新建与整理
 */
@AnAlias("ZmrAvatarPresenter")
@AnIntercept("chkZmrLogin")
public class ZmrAvatarPresenter implements ZmrConstants, CodeConstants
{
    /**
     * 插入头像，从页面拿到base64的字符串，转为byte[]存入数据库
     * 
     * @param request       请求
     * @param data          图片BASE64字符串
     * @throws Exception    异常
     */
    public static void doInsert(HttpRequest request, String data) throws Exception
    {
        int idx = data.indexOf(",");
        byte[] imageData = Base64.decode(data.substring(idx+1));
        
        ZmrAvatar avatar = new ZmrAvatar();
        avatar.setAvatarId(Ids.longId19());
        avatar.setAvatarType(0);
        
        byte[]  bytes50 = Images.resizePNG(imageData, 50, 50);
        if(bytes50 == null)
        {
            request.setResponseError("图片错误");
            return;
        }
        
        byte[]  bytes100 = Images.resizePNG(imageData, 100, 100);
        if(bytes100 == null)
        {
            request.setResponseError("图片错误");
            return;
        }
        
        byte[]  bytes150 = Images.resizePNG(imageData, 150, 150);
        if(bytes150 == null)
        {
            request.setResponseError("图片错误");
            return;
        }
        
        avatar.setAvatarTime(System.currentTimeMillis());
        avatar.setAvatar50(bytes50);
        avatar.setAvatar100(bytes100);
        avatar.setAvatar150(bytes150);
        
        ZmrBootstrap.table(request).insert(avatar);
    }
    
    /**
     * 更新头像，从页面拿到base64的字符串，转为byte[]更新到数据库
     * 
     * @param request       请求
     * @param avatarId      头像编号
     * @param data          图片BASE64字符串
     * @throws Exception    异常
     */
    public static void doUpdate(HttpRequest request, long avatarId, String data) throws Exception
    {
        int idx = data.indexOf(",");
        byte[] imageData = Base64.decode(data.substring(idx+1));
        
        byte[]  bytes50 = Images.resizePNG(imageData, 50, 50);
        if(bytes50 == null)
        {
            request.setResponseError("图片错误");
            return;
        }
        
        byte[]  bytes100 = Images.resizePNG(imageData, 100, 100);
        if(bytes100 == null)
        {
            request.setResponseError("图片错误");
            return;
        }
        
        byte[]  bytes150 = Images.resizePNG(imageData, 150, 150);
        if(bytes150 == null)
        {
            request.setResponseError("图片错误");
            return;
        }
        
        Updater updater = new Updater();
        updater.addMust("avatarId", avatarId);
        updater.addField("avatarTime", System.currentTimeMillis());
        updater.addField("avatar50", bytes50);
        updater.addField("avatar100", bytes100);
        updater.addField("avatar150", bytes150);
        
        ZmrBootstrap.table(request).update(ZmrAvatar.class, updater);
    }

    /**
     * 删除头像
     * 
     * @param request       请求
     * @param avatarId      头像编号
     * @throws Exception    异常
     */
    public static void doDelete(HttpRequest request, long avatarId) throws Exception
    {
        if(ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Selector("operatorAvatar", avatarId)) > 0)
        {
            request.setResponseError("该头像正在被操作员使用，不允许删除");
            return;
        }
        
        //删除系统头像
        ZmrBootstrap.table(request).delete(ZmrAvatar.class, avatarId);
    }
}
