/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 系统参数表 对应表《ZMR_PARAM》
 */
@AnAlias("ZmrParam")
@AnNew
@AnTable(table="ZMR_PARAM", key="PARAM_GROUP,PARAM_KEY", type="InnoDB")
public class ZmrParam implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="PARAM_GROUP", type="string,32", notNull=true)    private String paramGroup;    //1.参数组号
    @AnTableField(column="PARAM_KEY", type="string,32", notNull=true)    private String paramKey;    //2.参数键
    @AnTableField(column="PARAM_SEQ", type="int", notNull=true)    private int paramSeq;    //3.参数排序数
    @AnTableField(column="PARAM_VALUE", type="string,2000", notNull=false)    private String paramValue;    //4.参数值，允许为空
    @AnTableField(column="PARAM_TYPE", type="string,10", notNull=true)    private String paramType;    //5.参数类型，private表示私有不显示，protected表示显示，public表示公开可修改
    @AnTableField(column="PARAM_VALIDATE", type="string,200", notNull=false)    private String paramValidate;    //6.参数验证
    @AnTableField(column="PARAM_DESC", type="string,200", notNull=true)    private String paramDesc;    //7.参数描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getParamGroup()
    {
        return paramGroup;
    }

    public void setParamGroup(String paramGroup)
    {
        this.paramGroup = paramGroup;
    }

    public String getParamKey()
    {
        return paramKey;
    }

    public void setParamKey(String paramKey)
    {
        this.paramKey = paramKey;
    }

    public int getParamSeq()
    {
        return paramSeq;
    }

    public void setParamSeq(int paramSeq)
    {
        this.paramSeq = paramSeq;
    }

    public String getParamValue()
    {
        return paramValue;
    }

    public void setParamValue(String paramValue)
    {
        this.paramValue = paramValue;
    }

    public String getParamType()
    {
        return paramType;
    }

    public void setParamType(String paramType)
    {
        this.paramType = paramType;
    }

    public String getParamValidate()
    {
        return paramValidate;
    }

    public void setParamValidate(String paramValidate)
    {
        this.paramValidate = paramValidate;
    }

    public String getParamDesc()
    {
        return paramDesc;
    }

    public void setParamDesc(String paramDesc)
    {
        this.paramDesc = paramDesc;
    }

}
