/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 系统组织权限表 对应表《ZMR_ORG_RULE》
 */
@AnAlias("ZmrOrgRule")
@AnNew
@AnTable(table="ZMR_ORG_RULE", key="ORG_ID,MENU_CODE", type="InnoDB")
public class ZmrOrgRule implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="ORG_ID", type="long", notNull=true)    private long orgId;    //1.组织编号
    @AnTableField(column="MENU_CODE", type="string,32", notNull=true)    private String menuCode;    //2.菜单编码

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getOrgId()
    {
        return orgId;
    }

    public void setOrgId(long orgId)
    {
        this.orgId = orgId;
    }

    public String getMenuCode()
    {
        return menuCode;
    }

    public void setMenuCode(String menuCode)
    {
        this.menuCode = menuCode;
    }

}
