/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;
import java.sql.Timestamp;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 操作员日志表 对应表《ZMR_OPERATOR_LOG》
 */
@AnAlias("ZmrOperatorLog")
@AnNew
@AnTable(table="ZMR_OPERATOR_LOG", key="", type="InnoDB")
@AnIndex({@AnIndexValue(name="IX_ZMR_OPERATOR_LOG_ORG_TIME", column="ORG_ID,OPERATE_TIME", unique=false)})
public class ZmrOperatorLog implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="ORG_ID", type="long", notNull=true)    private long orgId;    //1.组织编号
    @AnTableField(column="OPERATOR_CODE", type="string,32", notNull=true)    private String operatorCode;    //2.操作员编码
    @AnTableField(column="OPERATE_TIME", type="datetime", notNull=true)    private Timestamp operateTime;    //3.操作时间,格式：yyyy-MM-dd hh:mm:ss
    @AnTableField(column="OPERATE_URL", type="string,512", notNull=true)    private String operateUrl;    //4.操作链接
    @AnTableField(column="OPERATE_DESC", type="string,512", notNull=false)    private String operateDesc;    //5.操作描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getOrgId()
    {
        return orgId;
    }

    public void setOrgId(long orgId)
    {
        this.orgId = orgId;
    }

    public String getOperatorCode()
    {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode)
    {
        this.operatorCode = operatorCode;
    }

    public Timestamp getOperateTime()
    {
        return operateTime;
    }

    public void setOperateTime(Timestamp operateTime)
    {
        this.operateTime = operateTime;
    }

    public String getOperateUrl()
    {
        return operateUrl;
    }

    public void setOperateUrl(String operateUrl)
    {
        this.operateUrl = operateUrl;
    }

    public String getOperateDesc()
    {
        return operateDesc;
    }

    public void setOperateDesc(String operateDesc)
    {
        this.operateDesc = operateDesc;
    }

}
