/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 组织部门表 对应表《ZMR_DEPT》
 */
@AnAlias("ZmrDept")
@AnNew
@AnTable(table="ZMR_DEPT", key="DEPT_ID", type="InnoDB")
public class ZmrDept implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="ORG_ID", type="long", notNull=true)    private long orgId;    //1.组织编号
    @AnTableField(column="PARENT_ID", type="long", notNull=true)    private long parentId;    //2.部门父编号
    @AnTableField(column="DEPT_ID", type="long", notNull=true)    private long deptId;    //3.部门编号
    @AnTableField(column="DEPT_NAME", type="string,32", notNull=true)    private String deptName;    //4.部门名称
    @AnTableField(column="DEPT_LEVEL", type="int", notNull=true)    private int deptLevel;    //5.部门级别
    @AnTableField(column="DEPT_STATUS", type="byte", notNull=true)    private int deptStatus;    //6.部门状态，0表示正常，1表示停用
    @AnTableField(column="DEPT_SEQ", type="int", notNull=true)    private int deptSeq;    //7.部门排序数
    @AnTableField(column="DEPT_PARENT_ALL", type="string,850", notNull=true)    private String deptParentAll;    //8.部门所有父节点，多个逗号隔开
    @AnTableField(column="DEPT_MANAGER", type="string,32", notNull=false)    private String deptManager;    //9.部门负责人
    @AnTableField(column="DEPT_SUB_MANAGER", type="string,200", notNull=false)    private String deptSubManager;    //10.部门副负责人，多个逗号隔开
    @AnTableField(column="DEPT_DESC", type="string,100", notNull=false)    private String deptDesc;    //11.部门描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getOrgId()
    {
        return orgId;
    }

    public void setOrgId(long orgId)
    {
        this.orgId = orgId;
    }

    public long getParentId()
    {
        return parentId;
    }

    public void setParentId(long parentId)
    {
        this.parentId = parentId;
    }

    public long getDeptId()
    {
        return deptId;
    }

    public void setDeptId(long deptId)
    {
        this.deptId = deptId;
    }

    public String getDeptName()
    {
        return deptName;
    }

    public void setDeptName(String deptName)
    {
        this.deptName = deptName;
    }

    public int getDeptLevel()
    {
        return deptLevel;
    }

    public void setDeptLevel(int deptLevel)
    {
        this.deptLevel = deptLevel;
    }

    public int getDeptStatus()
    {
        return deptStatus;
    }

    public void setDeptStatus(int deptStatus)
    {
        this.deptStatus = deptStatus;
    }

    public int getDeptSeq()
    {
        return deptSeq;
    }

    public void setDeptSeq(int deptSeq)
    {
        this.deptSeq = deptSeq;
    }

    public String getDeptParentAll()
    {
        return deptParentAll;
    }

    public void setDeptParentAll(String deptParentAll)
    {
        this.deptParentAll = deptParentAll;
    }

    public String getDeptManager()
    {
        return deptManager;
    }

    public void setDeptManager(String deptManager)
    {
        this.deptManager = deptManager;
    }

    public String getDeptSubManager()
    {
        return deptSubManager;
    }

    public void setDeptSubManager(String deptSubManager)
    {
        this.deptSubManager = deptSubManager;
    }

    public String getDeptDesc()
    {
        return deptDesc;
    }

    public void setDeptDesc(String deptDesc)
    {
        this.deptDesc = deptDesc;
    }

}
