/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.GetPostAction;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrRole;
import org.zhiqim.manager.dbo.ZmrRoleRule;
import org.zhiqim.orm.dbo.Selector;

/**
 * 角色权限列表<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class RoleRuleAction extends GetPostAction implements ZmrConstants
{
    protected void validate(HttpRequest request)
    {
        request.addValidate(new IsNotEmpty("roleId", "请选择角色"));
    }

    @Override
    protected void doGet(HttpRequest request) throws Exception
    {
        long roleId = request.getParameterLong("roleId");
        
        ZmrRole role = ZmrBootstrap.table(request).item(ZmrRole.class, roleId);
        if (role == null)
        {
            request.setResponseError("您选择的角色不存在，请选择一个有效的角色");
            return;
        }
        
        // 获取角色权限
        List<ZmrRoleRule> ruleList = ZmrBootstrap.table(request).list(ZmrRoleRule.class, new Selector("roleId", roleId));
        
        //获取角色所属组织的权限
        List<ZmrMenu> menuList = ZmrOrgDao.getMenuList(request, role.getOrgId());
        Tree<ZmrMenu> tree = TreeBuilder.newTree(menuList, "parentCode", "menuCode");
        
        request.setAttribute("role", role);
        request.setAttribute("ruleList", ruleList);
        request.setAttribute("tree", tree);
        request.setAttribute("menuSize", menuList.size());
    }

    @Override
    protected void doPost(HttpRequest request) throws Exception
    {
        long roleId = request.getParameterLong("roleId");
        String[] menuCodes = request.getParameterValuesOnCNT("rule");
        if (menuCodes == null)
            menuCodes = new String[0];
    
        // 判断角色是否存在
        if (ZmrBootstrap.table(request).count(ZmrRole.class, roleId) == 0)
        {
            request.returnHistory("您选择的角色不存在");
            return;
        }
        
        // 重置操作员权限
        ZmrBootstrap.table(request).delete(ZmrRoleRule.class, new Selector("roleId", roleId));
        if (menuCodes.length > 0)
        {
            List<ZmrRoleRule> bathList = new ArrayList<ZmrRoleRule>();
            for (int i = 0; i < menuCodes.length; i++)
            {
                ZmrRoleRule rule = new ZmrRoleRule();
                rule.setRoleId(roleId);
                rule.setMenuCode(menuCodes[i]);
                
                bathList.add(rule);
            }

            ZmrBootstrap.table(request).insertBatch(bathList);
        }
    }
}
