/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrRole;
import org.zhiqim.orm.dbo.Selector;

/**
 * 角色管理
 *
 * @version v1.0.0 @author zouzhigang 2015-5-29 新建与整理
 */
public class RoleAction extends StdSwitchAction implements ZmrConstants
{

    @Override
    protected void validateId(HttpRequest request)
    {
        request.addValidate(new IsInteger("roleId", "请选择一个选项"));
    }

    @Override
    protected void validateForm(HttpRequest request)
    {
        request.addValidate(new IsInteger("roleId", "请选择一个选项"));
        request.addValidate(new IsLen("roleName", "角色名称不能为空且不能超过32个汉字", 1, 32));
        request.addValidate(new IsIntegerValue("roleStatus", "角色状态范围为[0, 1]之间", 0, 1));
        request.addValidate(new IsIntegerValue("roleSeq", "角色排序必须是[0, 999999]范围的非负整数", 0, 999999));
    }

    @Override
    protected void list(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        
        List<ZmrRole> list = ZmrBootstrap.table(request).list(ZmrRole.class, new Selector("orgId", orgId).addOrderbyAsc("roleSeq"));
        request.setAttribute("list", list);
    }
    
    @Override
    protected void add(HttpRequest request) throws Exception
    {
    }

    @Override
    protected void insert(HttpRequest request) throws Exception
    {
        ZmrRole item = request.getParameter(ZmrRole.class);
        item.setOrgId(request.getSessionUser(ZmrSessionUser.class).getSelectedOrgId());
        ZmrBootstrap.table(request).insert(item);
    }

    @Override
    protected void modify(HttpRequest request) throws Exception
    {
        long roleId = request.getParameterLong("roleId");
        ZmrRole item = ZmrBootstrap.table(request).item(ZmrRole.class, roleId);
        if (item == null)
        {
            request.returnHistory("角色不存在，请选择正确的角色");
            return;
        }
        
        request.setAttribute("item", item);
    }

    @Override
    protected void update(HttpRequest request) throws Exception
    {
        ZmrRole item = request.getParameter(ZmrRole.class);
        ZmrBootstrap.table(request).update(item);
    }

    @Override
    protected void delete(HttpRequest request) throws Exception
    {
        long roleId = request.getParameterLong("roleId");
        if (ZmrBootstrap.table(request).count(ZmrRole.class, roleId) == 0)
        {
            request.returnHistory("角色不存在，请选择成确的角色");
            return;
        }
        
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Selector().addMustLike("operatorRole", roleId)) > 0)
        {
            request.returnHistory("该角色已有操作员，请删除角色成员后再删除本角色");
            return;
        }
        
        ZmrBootstrap.table(request).delete(ZmrRole.class, roleId);
    }
}